<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."/mystery/_class/ReportManager/class.Category.php");
include_once(PATH_TO_ROOT."/mystery/_class/ReportManager/class.Question.php");
include_once(PATH_TO_ROOT."/mystery/_class/ReportManager/class.ReportGenerator.php");
include_once(PATH_TO_ROOT."mystery/_class/ReportManager/class.Calculator.php");

class BaseDBController
{
    protected $projectName;
    protected $db;

    public function __construct($db, $projectName)
    {
        $this->db = $db;
        $this->projectName = $projectName;
    }
}

class ReportManager extends BaseDBController
{
    protected $labelsLanguageID = 91;
    private $calculator;
    private $ultimativeCalculator;
    private $noQuestionScores;
    private $questionNames;
    private $dbColumnNames;
    private $records;
    private $ultimativeScores;
    private $structure;
    private $specialColumns;
    private $groups;
    private $isPositiveNegative;
    private $tableTitle;
    private $languagePack;

    public function __construct($db, $projectName, $languagePack, $languageId, $groups = null, $isPositiveNegative = FALSE, $tableTitle = "")
    {
        parent::__construct($db, $projectName);
        $this->labelsLanguageID = $languageId;
        $this->tableTitle = $tableTitle;
        $this->isPositiveNegative = $isPositiveNegative;
        $this->structure = $this->intiQuestionnaireStructure();
        $this->calculator = $this->initCalculator($groups);
        $this->ultimativeCalculator = $this->initUltimativeCalculator();
        $this->languagePack = $languagePack;
    }

    protected function initCalculator($groups)
    {
        if(!is_null($groups))
        {
            return $this->calculator = new GroupCalculator($this->structure);
        }
        else if($this->isPositiveNegative)
        {
            return $this->calculator = new PositiveNegativeCalculator($this->structure);
        }

        return $this->calculator = new Calculator($this->structure);
    }

    public function generateReport()
    {
        $reportGenerator = $this->getReportGenerator();
        return $reportGenerator->getGenerateHtml();
    }
    public function getReportGenerator()
    {
        if(!is_null($this->groups))
        {
            $reportGenerator = new ReportGeneratorGroups($this->calculator, $this->ultimativeCalculator, $this->languagePack);
            $reportGenerator->addReportGenerator(new ReportGeneratorGroupsReview($this->calculator, $this->ultimativeCalculator, $this->languagePack));
        }
        else if($this->isPositiveNegative)
        {
            $reportGenerator = new ReportGeneratorNegativePositive($this->calculator, $this->ultimativeCalculator, $this->languagePack, $this->specialColumns, $this->tableTitle);
        }
        else
        {
            $reportGenerator = new ReportGenerator($this->calculator, $this->ultimativeCalculator, $this->languagePack, $this->specialColumns);
        }

        return $reportGenerator;
    }

    public function getStructure()
    {
        return $this->structure;
    }

    public function getCalculator()
    {
        return $this->calculator;
    }

    public function getRecords()
    {
        return $this->records;
    }

    private function calculateRecords()
    {
        $this->calculator->calculateRecords($this->records);
    }

    private function initUltimativeCalculator()
    {
        $records = $this->LoadRecords("SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projectName."_structure WHERE flag_bad = 101", FALSE);
        $ultimativeCalculator = new UltimativeCalculator( $this->structure );
        $ultimativeCalculator->calculateRecords($records);

        return $ultimativeCalculator;
    }

    private function intiQuestionnaireStructure()
    {
        $mainCategory = new Category("0", "main", TRUE);
        $sql = " SELECT a.id,a.id_sup,a.idLab,a.is_leaf, b.lngText  FROM  ".DB_WARPIT_WEBCATI.".".$this->projectName."_tree as a
					LEFT JOIN ".DB_WARPIT_WEBCATI.".".$this->projectName."_language as b
						ON 			a.id_question = b.id_question
							AND  	b.id_text_type = 2
							AND 	b.id_language = ".$this->labelsLanguageID."
                            ORDER BY a.is_leaf ASC, id_sup ASC, a.orderBy ASC";
        //echo "$sql <br>";
        //ORDER BY id_sup ASC, orderBy ASC ";
		$res = $this->db->SQLexecute($sql);
        if ($this->db->NumRows($res) == 0) $this->noQuestionScores = true;

        $treeRows = Array();
        while($zad = $this->db->fetchAssoc($res)){
            $treeRows[$zad["id"]] = $zad;
        }

        $sql = " SELECT a .* , b.q_name, b.tip_sql, b.id as id_question_mystery
					FROM ".DB_WARPIT_WEBCATI.".".$this->projectName."_mystery AS a
					LEFT JOIN ".DB_WARPIT_WEBCATI.".".$this->projectName." AS b ON a.id_question = b.id";
        //echo "$sql<br>";
        $res = $this->db->SQLexecute($sql);
        while($zad = $this->db->fetchAssoc($res)){
            $treeRows[$zad["id_question"]]["answers"][] = $zad;
        }
        //var_dump($treeRows);
		foreach ($treeRows as $row)
        {
			if($row["id_sup"] == 0 && !$row["is_leaf"])
            {
                //echo "adding to main(" . $row["id_sup"] . ") - category " .$row["idLab"]. "<br>";
                $newCategory = new Category($row["id"], $row["idLab"]);
                $mainCategory->addCategory($newCategory);
            }
            else if (!$row["is_leaf"])
            {
                $category = ($row["id_sup"] == 0) ? $mainCategory : $mainCategory->getCategoryRecursive($row["id_sup"]);
                $newCategory = new Category($row["id"], $row["idLab"]);
                //echo "adding to " . $category->getName() . "(" . $row["id_sup"] . ") - category " .$row["idLab"]. "<br>";
                $category->addCategory($newCategory);
            }
            else
            {
                $category = ($row["id_sup"] == 0) ? $mainCategory : $mainCategory->getCategoryRecursive($row["id_sup"]);
                //echo "question<br>";
                //var_dump($row["id"], $row["idLab"], $row["id_sup"], $category->getName());
                if($row["is_leaf"])
                {
                    $question = new Question($row["idLab"], $row["lngText"], $category->getId());
                    if(isset($row["answers"]))
                    {
                        foreach ($row["answers"] as $ans) {
                            $question->setTipSql($ans["tip_sql"]);

                            if($ans["tip_sql"] == 2){
                                $question->addAnswer($ans["sc_value"],  $ans["id_legend"], $ans["id_answer"]);
                            }else {
                                $question->addAnswer($ans["sc_value"], $ans["id_answer"]);
                            }


                        }
                    }
                    if(!is_null($question->getAnswersDatabaseName()))
                    {
                        foreach ($question->getAnswersDatabaseName() as $columnName)
                        {
                            $this->dbColumnNames[] = $columnName;
                        }
                    }

                    $this->questionNames[] = $question->getName();
                    $category->addQuestion($question);
                    //var_dump($category);
                    //echo "--------------------------------<br>";
                }
            }
		}
        $this->dbColumnNames[] = "Address_1";
        return $mainCategory;
    }

    public function LoadRecords($id, $calculateRecords = TRUE, $groups = null)
    {
        if(!is_null($groups))
        {
            $sqlId = "SELECT a.id_structure, a.id_sup,b.idLab FROM " . DB_WARPIT_MYSTERY . "._Visits a LEFT JOIN " . DB_WARPIT_MYSTERY . "._Visits b ON a.id_sup = b.id WHERE a.id_sup IN (" . $groups . ")";
            //$sqlId = "SELECT a.id_structure, a.id_sup,b.idLab FROM _Visits a LEFT JOIN _Visits b ON a.id_sup = b.id WHERE a.id_sup IN (" . $groups . ")";
            $res = $this->db->SQLexecute($sqlId);
            while ($rec = $this->db->fetchAssoc($res))
            {
                $this->groups[$rec["id_sup"]]["ids"][] = $rec["id_structure"];
                $this->groups[$rec["id_sup"]]["label"] = $rec["idLab"];
                $ids[] = $rec["id_structure"];
            }

            $sql = "SELECT id,".implode(",",$this->dbColumnNames)."
    					FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projectName."_structure
    						WHERE id IN (" . implode(",", $ids) . ") ";
            $this->calculator->setGroups($this->groups);
        }
        else
        {
            $sql = "SELECT id,".implode(",",$this->dbColumnNames)."
    					FROM ".DB_WARPIT_WEBCATI_BASE.".".$this->projectName."_structure
    						WHERE id IN (".$id.") ORDER BY id";
        }
		$res = $this->db->SQLexecute($sql);

        $rtnRecords = Array();
		while ($rec = $this->db->fetchAssoc($res)){ $rtnRecords[] = $rec;}

        if($calculateRecords)
        {
            $this->records = $rtnRecords;
            foreach ($this->records as $rec) {
                $this->specialColumns[$rec["id"]] = $rec["Address_1"];
            }


            $this->calculateRecords();
        }
        return $rtnRecords;
	}
}
?>
