<?php
/**
 * Startup program constants dkjf
 * Here we define Warpit constants for database access, database names, absolute path to Warpit
 *
 * @author RMplus d.o.o.
 * @version 28/12/2009
 * @package /
 */

header("Content-type: text/html; charset=utf-8");
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

ini_set('display_errors', '0');     # show errors...
//error_reporting(E_ERROR | E_WARNING | E_PARSE);  # ...and log them
//error_reporting(E_ERROR | E_PARSE);  # ...and log them

date_default_timezone_set('Europe/Ljubljana');
// Page title
define("WARPIT_TITLE", "RMplus - WARPIT");

// Initialize database connection
if ($_GET['nfield'] == 1) $sessionHandling = 1;

include_once("_dirinfo.php");
//include_once(PATH_TO_ROOT."_support/class.logger.php"); //ZAKOMENTIRANO 15.4.2013 BY SANDI ZARADI KONFLIKTA Z ISTOIMENSKIM CLASSOM V SORS (CALL CENTER)

include_once(PATH_TO_ROOT.'_config/dbConfig.php');
include_once(PATH_TO_ROOT.'vendor/autoload.php');

if(defined('WARPIT_MAINTENANCE_MODE') === true){
    include_once("_forms/forms.maintenance.mode.php");
    exit;
}

spl_autoload_register(function ($className) {
    $container = container();
    $facades = $container['facades'];

    if (isset($facades[$className])) {
        $instance = $container->make($className);
        SolveX\Facades\Facade::setInstance($facades[$className], $instance);
        class_alias($facades[$className], $className);
    }
});

include_once(PATH_TO_ROOT.'_support/htmlcleaner/HTMLPurifier.auto.php');
include_once(PATH_TO_ROOT.'_support/convertVars.php');
include_once(PATH_TO_ROOT."_support/class.UserSession.php");

$db->ChangeDatabase(DB_WARPIT_MAIN);
$UserSession = new UserSession($db);

if(!$UserSession->isLoggedin() && !$sessionHandling)
{
	echo "{success:false,error:'sessionTimeout'}";
	exit;
}
//most components use this to identfy the unique tab!
$tabId = $_POST['uniqueTabId'];


?>
