<?php

class RouteTest extends PHPUnit_Framework_TestCase
{

    public function setUp()
    {
        $_SERVER['REQUEST_METHOD'] = 'GET';
    }


    public function tearDown()
    {
    }


    public function testNoParameters()
    {
        $routeCalled = false;

        Route::get('/command/admin', function() use(&$routeCalled) {
            $routeCalled = true;
        });

        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/command/admin';
        $_SERVER['REQUEST_METHOD'] = 'GET';

        Route::dispatch();

        $this->assertTrue($routeCalled);
    }


    public function testMiddleware()
    {
        $calls = 0;

        $c = function() use(&$calls) {
            $calls++;
        };

        Route::get('/command/middleware', $c, $c, $c, $c);

        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/command/middleware';
        $_SERVER['REQUEST_METHOD'] = 'GET';

        Route::dispatch();

        $this->assertEquals(4, $calls);
    }


    public function testParameters()
    {
        Route::get('/users/{userId}/videos/{videoId}', function($userId, $videoId) {
            $this->assertEquals(42, $userId);
            $this->assertEquals(13, $videoId);
        });

        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/users/42/videos/13';
        $_SERVER['REQUEST_METHOD'] = 'GET';

        Route::dispatch();

        // If route is not called, exception 404 is thrown.
    }


    public function testDashParameters()
    {
        Route::get('/dashes/dash-{id}', function($id) {
            $this->assertEquals(45, $id);
        });

        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/dashes/dash-45';
        $_SERVER['REQUEST_METHOD'] = 'GET';

        Route::dispatch();

        // If route is not called, exception 404 is thrown.
    }


    public function testParametersTrailingSlash()
    {
        $numTimesCalled = 0;

        Route::get('/users/{userId}/favorites', function($userId) use(&$numTimesCalled) {
            $this->assertEquals(42, $userId);
            $numTimesCalled++;
        });

        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/users/42/favorites';
        $_SERVER['REQUEST_METHOD'] = 'GET';
        Route::dispatch();

        $_SERVER['REQUEST_URI'] = 'http://domain.com/users/42/favorites/';
        Route::dispatch();

        $this->assertEquals(2, $numTimesCalled);
    }


    /**
     * @expectedException Exception
     */
    public function testMatchFail()
    {
        $_SERVER['SCRIPT_NAME'] = '/index.php';
        $_SERVER['REQUEST_URI'] = 'http://domain.com/this/route/does/not/exist';
        $_SERVER['REQUEST_METHOD'] = 'GET';

        Route::dispatch();
    }
}
