<?php

namespace SolveX\Support;

use Illuminate\Database\Capsule\Manager as Capsule;

class WarpitConfig
{

    /**
     * Parses .env file into an array of key => value pairs (returned value).
     * Handles 'false', 'true' values.
     * Does *NOT* affect the environment ($_ENV/$_SERVER/getenv).
     */
    public function load()
    {
        $capsule = new Capsule;
        $capsule->addConnection([
            'driver'    => 'mysql',
            'host'      => WARPIT_HOST,
            'username'  => MYSQL_USER,
            'password'  => MYSQL_PASS,
            'database'  => DB_WARPIT_MAIN,
            'charset'   => 'utf8',
            'collation' => 'utf8_unicode_ci',
            'prefix'    => '',
            'options'   => [
                \PDO::ATTR_STRINGIFY_FETCHES => true,
                \PDO::MYSQL_ATTR_LOCAL_INFILE => true,
            ],
        ]);
        $db = $capsule->getConnection();
        $config = $db->select('SELECT cName, cValue FROM _WarpitConfig
                                WHERE prefix = ? OR prefix = ? OR prefix = ?',
                               ['warpit-api', 'paths', 'database']);
        $env = [];
        foreach($config as $conf)
        {
          $uCName = strtoupper($conf->cName);
          $env[$uCName] = $conf->cValue;
        }
        return $env;
    }
}
