<?php

namespace SolveX\Session;

/**
 * A proxy class to SessionHandler. Intended to transparently wrap session handlers with
 * additional functionality.
 *
 * See SessionLockingProxy for example.
 */
abstract class SessionProxy
{
    protected $handler;


    public function __construct($handler)
    {
        $this->handler = $handler;
    }


    public function open($savePath, $sessionName)
    {
        return $this->handler->open($savePath, $sessionName);
    }


    public function close()
    {
        return $this->handler->close();
    }


    public function read($sessionId)
    {
        return $this->handler->read($sessionId);
    }


    public function write($sessionId, $data)
    {
        return $this->handler->write($sessionId, $data);
    }


    public function destroy($sessionId)
    {
        return $this->handler->destroy($sessionId);
    }


    public function gc($maxlifetime)
    {
        return $this->handler->gc($maxlifetime);
    }
}
