<?php

namespace SolveX\Http;

use SolveX\Exceptions\FileException;

/**
 * HTTP uploaded file ($_FILES).
 */
class UploadedFile
{
    protected $originalName;
    protected $mimeType;
    protected $path;
    protected $size;

    /**
     * @link http://php.net/manual/en/features.file-upload.errors.php
     */
    protected $error;

    public function __construct($path, $originalName, $mimeType = null, $size = null, $error = null)
    {
        $this->path = $path;
        $this->originalName = $originalName;
        $this->mimeType = $mimeType ?: 'application/octet-stream';
        $this->size = $size;
        $this->error = $error ?: UPLOAD_ERR_OK;
    }

    /**
     * The original name of the uploaded file.
     */
    public function originalName()
    {
        return $this->originalName;
    }

    /**
     * Moves the file to a new location.
     *
     * @param string $directory The destination folder
     * @param string $name      The new file name
     */
    public function move($directory, $name = null)
    {
        if (! is_writable($directory))
            throw new FileException("Destination directory $directory is not writable!");

        $target = rtrim($directory, '/\\') . DIRECTORY_SEPARATOR . ($name === null ? $this->originalName : $name);

        move_uploaded_file($this->path, $target);
    }
}