#!/usr/bin/env bash

SECRET_CONTENT=$(docker run --rm -v $(pwd)/deployment:/workdir/deployment --network=host -e VAULT_ADDRESS -e X_VAULT_TOKEN -e TENANT -e BRANCH ${CI_REGISTRY}/solve-x/vault/client:master php render-secret.php "$1")
CONTENT_HASH=$(echo -n "$SECRET_CONTENT" | md5sum | awk '{print $1}')
EXISTING_SECRET=$(docker secret ls -q -f label=content_hash=${CONTENT_HASH})

if [[ ! "$EXISTING_SECRET" ]]; then
    echo "$SECRET_CONTENT" | docker secret create --label content_hash="${CONTENT_HASH}" "${2}_${CONTENT_HASH}" - > /dev/null
fi

docker secret ls -f label=content_hash="${CONTENT_HASH}" --format '{{.Name}}'
