<?php

use Phinx\Migration\AbstractMigration;

class AddTextPaddingToSliderPlugin extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $tableName = DB_WARPIT_WEBCATI_BASE . '.`_Plugin_label`';
        $sql ="INSERT INTO $tableName (`name`, `label`, `type`, `default_value`, `group`, `id_plugin`) VALUES
            ('left_text_padding', 'Padding (left side text)', 'int', '0', 'Additional text', 9),
            ('right_text_padding', 'Padding (right side text)', 'int', '0', 'Additional text', 9)";
        $this->execute($sql);

        $tableName = DB_WARPIT_WEBCATI_BASE . '.`_plugin_slider`';
        $sql ="ALTER TABLE $tableName ADD COLUMN `left_text_padding` INT(11) NOT NULL DEFAULT '0',
	                                        ADD COLUMN `right_text_padding` INT(11) NOT NULL DEFAULT '0';";
        $this->execute($sql);
    }
}
