--
-- Table structure for table `_PermissionGroups`
--

DROP TABLE IF EXISTS `_PermissionGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_PermissionGroups` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `id_sup` int(4) NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  `idLab` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_PermissionGroups`
--

LOCK TABLES `_PermissionGroups` WRITE;
/*!40000 ALTER TABLE `_PermissionGroups` DISABLE KEYS */;
INSERT INTO `_PermissionGroups` VALUES (1,0,0,'Administrator'),(2,0,0,'User');
/*!40000 ALTER TABLE `_PermissionGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_PermissionLink`
--

DROP TABLE IF EXISTS `_PermissionLink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_PermissionLink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_permission` int(4) NOT NULL,
  `id_permission_group` int(4) NOT NULL DEFAULT '0',
  `id_user` smallint(6) NOT NULL DEFAULT '0',
  `allow` tinyint(1) NOT NULL,
  `deny` tinyint(1) NOT NULL,
  `p_type` int(11) NOT NULL DEFAULT '0' COMMENT '0 - Basic, 1 - Webcati menu, 2 - Userspool menu',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_permission` (`id_permission`,`id_permission_group`,`id_user`,`p_type`)
) ENGINE=MyISAM AUTO_INCREMENT=381 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_PermissionLink`
--

LOCK TABLES `_PermissionLink` WRITE;
/*!40000 ALTER TABLE `_PermissionLink` DISABLE KEYS */;
INSERT INTO `_PermissionLink` VALUES (1,1,1,0,1,0,0),(2,2,1,0,1,0,0),(3,14,0,1,1,0,0),(4,13,0,1,1,0,0),(5,12,0,1,1,0,0),(6,15,0,1,1,0,0),(7,7,1,0,1,0,0),(8,15,1,0,1,0,0),(9,6,1,0,1,0,0),(10,8,1,0,1,0,0),(11,3,1,0,1,0,0),(12,10,1,0,1,0,0),(13,5,1,0,1,0,0),(14,4,1,0,1,0,0),(15,11,1,0,1,0,0),(16,14,0,2,1,0,0),(17,16,0,2,1,0,0),(18,17,0,2,1,0,0),(19,18,0,2,1,0,0),(20,24,0,2,1,0,0),(21,23,0,2,1,0,0),(22,25,0,2,1,0,0),(23,20,0,2,1,0,0),(24,34,0,2,1,0,0),(25,32,0,2,1,0,0),(26,35,0,2,1,0,0),(27,30,0,2,1,0,0),(28,33,0,2,1,0,0),(29,31,0,2,1,0,0),(30,22,0,2,1,0,0),(31,45,0,2,1,0,0),(32,46,0,2,1,0,0),(33,47,0,2,1,0,0),(34,21,0,2,1,0,0),(35,37,0,2,1,0,0),(36,38,0,2,1,0,0),(37,36,0,2,1,0,0),(38,42,0,2,1,0,0),(39,43,0,2,1,0,0),(40,44,0,2,1,0,0),(41,19,0,2,1,0,0),(42,48,0,2,1,0,0),(43,50,0,2,1,0,0),(44,49,0,2,1,0,0),(45,29,0,2,1,0,0),(46,28,0,2,1,0,0),(47,51,0,2,1,0,0),(48,27,0,2,1,0,0),(49,26,0,2,1,0,0),(50,39,0,2,1,0,0),(51,40,0,2,1,0,0),(52,41,0,2,1,0,0),(53,13,0,2,1,0,0),(54,12,0,2,1,0,0),(55,9,0,2,1,0,0),(56,1,0,2,1,0,0),(57,7,0,2,1,0,0),(58,15,0,2,1,0,0),(59,6,0,2,1,0,0),(60,10,0,2,1,0,1),(61,63,0,2,1,0,1),(62,102,0,2,1,0,1),(63,18,0,2,1,0,1),(64,60,0,2,1,0,1),(65,17,0,2,1,0,1),(66,64,0,2,1,0,1),(67,62,0,2,1,0,1),(68,46,0,2,1,0,1),(69,16,0,2,1,0,1),(70,51,0,2,1,0,1),(71,1,0,2,1,0,1),(72,32,0,2,1,0,1),(73,28,0,2,1,0,1),(74,22,0,2,1,0,1),(75,42,0,2,1,0,1),(76,20,0,2,1,0,1),(77,43,0,2,1,0,1),(78,52,0,2,1,0,1),(79,3,0,2,1,0,1),(80,48,0,2,1,0,1),(81,68,0,2,1,0,1),(82,86,0,2,1,0,1),(83,87,0,2,1,0,1),(84,83,0,2,1,0,1),(85,50,0,2,1,0,1),(86,53,0,2,1,0,1),(87,2,0,2,1,0,1),(88,6,0,2,1,0,1),(89,44,0,2,1,0,1),(90,45,0,2,1,0,1),(91,35,0,2,1,0,1),(92,33,0,2,1,0,1),(93,36,0,2,1,0,1),(94,37,0,2,1,0,1),(95,19,0,2,1,0,1),(96,58,0,2,1,0,1),(97,59,0,2,1,0,1),(98,57,0,2,1,0,1),(99,65,0,2,1,0,1),(100,47,0,2,1,0,1),(101,56,0,2,1,0,1),(102,55,0,2,1,0,1),(103,54,0,2,1,0,1),(104,38,0,2,1,0,1),(105,5,0,2,1,0,1),(106,26,0,2,1,0,1),(107,24,0,2,1,0,1),(108,7,0,2,1,0,1),(109,25,0,2,1,0,1),(110,67,0,2,1,0,1),(111,27,0,2,1,0,1),(112,61,0,2,1,0,1),(113,49,0,2,1,0,1),(114,39,0,2,1,0,1),(115,30,0,2,1,0,1),(116,31,0,2,1,0,1),(117,9,0,2,1,0,1),(118,70,0,2,1,0,1),(119,69,0,2,1,0,1),(120,88,0,2,1,0,1),(121,90,0,2,1,0,1),(122,94,0,2,1,0,1),(123,95,0,2,1,0,1),(124,93,0,2,1,0,1),(125,100,0,2,1,0,1),(126,101,0,2,1,0,1),(127,92,0,2,1,0,1),(128,96,0,2,1,0,1),(129,97,0,2,1,0,1),(130,89,0,2,1,0,1),(131,91,0,2,1,0,1),(132,99,0,2,1,0,1),(133,98,0,2,1,0,1),(134,8,0,2,1,0,0),(135,2,0,2,1,0,2),(136,3,0,2,1,0,0),(137,10,0,2,1,0,0),(138,5,0,2,1,0,0),(139,4,0,2,1,0,0),(140,11,0,2,1,0,0),(141,2,0,2,1,0,0),(142,16,0,1,1,0,0),(143,17,0,1,1,0,0),(144,18,0,1,1,0,0),(145,24,0,1,1,0,0),(146,23,0,1,1,0,0),(147,25,0,1,1,0,0),(148,20,0,1,1,0,0),(149,34,0,1,1,0,0),(150,32,0,1,1,0,0),(151,35,0,1,1,0,0),(152,30,0,1,1,0,0),(153,33,0,1,1,0,0),(154,31,0,1,1,0,0),(155,22,0,1,1,0,0),(156,45,0,1,1,0,0),(157,46,0,1,1,0,0),(158,47,0,1,1,0,0),(159,21,0,1,1,0,0),(160,37,0,1,1,0,0),(161,38,0,1,1,0,0),(162,36,0,1,1,0,0),(163,42,0,1,1,0,0),(164,43,0,1,1,0,0),(165,44,0,1,1,0,0),(166,19,0,1,1,0,0),(167,48,0,1,1,0,0),(168,50,0,1,1,0,0),(169,49,0,1,1,0,0),(170,29,0,1,1,0,0),(171,28,0,1,1,0,0),(172,51,0,1,1,0,0),(173,27,0,1,1,0,0),(174,26,0,1,1,0,0),(175,39,0,1,1,0,0),(176,40,0,1,1,0,0),(177,41,0,1,1,0,0),(178,9,0,1,1,0,0),(179,1,0,1,1,0,0),(180,7,0,1,1,0,0),(181,6,0,1,1,0,0),(182,10,0,1,1,0,1),(183,63,0,1,1,0,1),(184,102,0,1,1,0,1),(185,18,0,1,1,0,1),(186,60,0,1,1,0,1),(187,17,0,1,1,0,1),(188,64,0,1,1,0,1),(189,62,0,1,1,0,1),(190,46,0,1,1,0,1),(191,16,0,1,1,0,1),(192,51,0,1,1,0,1),(193,1,0,1,1,0,1),(194,32,0,1,1,0,1),(195,104,0,1,1,0,1),(196,28,0,1,1,0,1),(197,22,0,1,1,0,1),(198,42,0,1,1,0,1),(199,20,0,1,1,0,1),(200,43,0,1,1,0,1),(201,52,0,1,1,0,1),(202,3,0,1,1,0,1),(203,48,0,1,1,0,1),(204,103,0,1,1,0,1),(205,68,0,1,1,0,1),(206,86,0,1,1,0,1),(207,87,0,1,1,0,1),(208,83,0,1,1,0,1),(209,50,0,1,1,0,1),(210,53,0,1,1,0,1),(211,2,0,1,1,0,1),(212,6,0,1,1,0,1),(213,44,0,1,1,0,1),(214,45,0,1,1,0,1),(215,35,0,1,1,0,1),(216,33,0,1,1,0,1),(217,36,0,1,1,0,1),(218,37,0,1,1,0,1),(219,19,0,1,1,0,1),(220,58,0,1,1,0,1),(221,59,0,1,1,0,1),(222,57,0,1,1,0,1),(223,65,0,1,1,0,1),(224,47,0,1,1,0,1),(225,56,0,1,1,0,1),(226,55,0,1,1,0,1),(227,54,0,1,1,0,1),(228,38,0,1,1,0,1),(229,5,0,1,1,0,1),(230,26,0,1,1,0,1),(231,24,0,1,1,0,1),(232,7,0,1,1,0,1),(233,25,0,1,1,0,1),(234,67,0,1,1,0,1),(235,27,0,1,1,0,1),(236,61,0,1,1,0,1),(237,49,0,1,1,0,1),(238,39,0,1,1,0,1),(239,30,0,1,1,0,1),(240,31,0,1,1,0,1),(241,9,0,1,1,0,1),(242,70,0,1,1,0,1),(243,69,0,1,1,0,1),(244,88,0,1,1,0,1),(245,90,0,1,1,0,1),(246,94,0,1,1,0,1),(247,95,0,1,1,0,1),(248,93,0,1,1,0,1),(249,100,0,1,1,0,1),(250,101,0,1,1,0,1),(251,92,0,1,1,0,1),(252,96,0,1,1,0,1),(253,97,0,1,1,0,1),(254,89,0,1,1,0,1),(255,91,0,1,1,0,1),(256,99,0,1,1,0,1),(257,98,0,1,1,0,1),(258,8,0,1,1,0,0),(259,3,0,1,1,0,0),(260,10,0,1,1,0,0),(261,5,0,1,1,0,0),(262,4,0,1,1,0,0),(263,11,0,1,1,0,0),(264,2,0,1,1,0,0),(265,14,1,0,1,0,0),(266,16,1,0,1,0,0),(267,17,1,0,1,0,0),(268,18,1,0,1,0,0),(269,24,1,0,1,0,0),(270,23,1,0,1,0,0),(271,25,1,0,1,0,0),(272,20,1,0,1,0,0),(273,34,1,0,1,0,0),(274,32,1,0,1,0,0),(275,35,1,0,1,0,0),(276,30,1,0,1,0,0),(277,33,1,0,1,0,0),(278,31,1,0,1,0,0),(279,22,1,0,1,0,0),(280,45,1,0,1,0,0),(281,46,1,0,1,0,0),(282,47,1,0,1,0,0),(283,21,1,0,1,0,0),(284,37,1,0,1,0,0),(285,38,1,0,1,0,0),(286,36,1,0,1,0,0),(287,42,1,0,1,0,0),(288,43,1,0,1,0,0),(289,44,1,0,1,0,0),(290,19,1,0,1,0,0),(291,48,1,0,1,0,0),(292,50,1,0,1,0,0),(293,49,1,0,1,0,0),(294,29,1,0,1,0,0),(295,28,1,0,1,0,0),(296,51,1,0,1,0,0),(297,27,1,0,1,0,0),(298,26,1,0,1,0,0),(299,39,1,0,1,0,0),(300,40,1,0,1,0,0),(301,41,1,0,1,0,0),(302,13,1,0,1,0,0),(303,12,1,0,1,0,0),(304,9,1,0,1,0,0),(305,1,1,0,1,0,1),(306,32,1,0,1,0,1),(307,22,1,0,1,0,1),(308,28,1,0,1,0,1),(309,20,1,0,1,0,1),(310,43,1,0,1,0,1),(311,42,1,0,1,0,1),(312,104,1,0,1,0,1),(313,35,1,0,1,0,1),(314,36,1,0,1,0,1),(315,37,1,0,1,0,1),(316,33,1,0,1,0,1),(317,2,1,0,1,0,1),(318,65,1,0,1,0,1),(319,10,1,0,1,0,1),(320,62,1,0,1,0,1),(321,16,1,0,1,0,1),(322,46,1,0,1,0,1),(323,51,1,0,1,0,1),(324,63,1,0,1,0,1),(325,60,1,0,1,0,1),(326,18,1,0,1,0,1),(327,102,1,0,1,0,1),(328,64,1,0,1,0,1),(329,17,1,0,1,0,1),(330,38,1,0,1,0,1),(331,5,1,0,1,0,1),(332,26,1,0,1,0,1),(333,88,1,0,1,0,1),(334,90,1,0,1,0,1),(335,94,1,0,1,0,1),(336,95,1,0,1,0,1),(337,89,1,0,1,0,1),(338,92,1,0,1,0,1),(339,96,1,0,1,0,1),(340,97,1,0,1,0,1),(341,91,1,0,1,0,1),(342,98,1,0,1,0,1),(343,99,1,0,1,0,1),(344,93,1,0,1,0,1),(345,100,1,0,1,0,1),(346,101,1,0,1,0,1),(347,6,1,0,1,0,1),(348,44,1,0,1,0,1),(349,45,1,0,1,0,1),(350,24,1,0,1,0,1),(351,7,1,0,1,0,1),(352,25,1,0,1,0,1),(353,49,1,0,1,0,1),(354,27,1,0,1,0,1),(355,61,1,0,1,0,1),(356,67,1,0,1,0,1),(357,52,1,0,1,0,1),(358,53,1,0,1,0,1),(359,3,1,0,1,0,1),(360,48,1,0,1,0,1),(361,50,1,0,1,0,1),(362,103,1,0,1,0,1),(363,68,1,0,1,0,1),(364,86,1,0,1,0,1),(365,83,1,0,1,0,1),(366,87,1,0,1,0,1),(367,19,1,0,1,0,1),(368,57,1,0,1,0,1),(369,58,1,0,1,0,1),(370,59,1,0,1,0,1),(371,9,1,0,1,0,1),(372,69,1,0,1,0,1),(373,70,1,0,1,0,1),(374,39,1,0,1,0,1),(375,30,1,0,1,0,1),(376,31,1,0,1,0,1),(377,47,1,0,1,0,1),(378,54,1,0,1,0,1),(379,55,1,0,1,0,1),(380,56,1,0,1,0,1);
/*!40000 ALTER TABLE `_PermissionLink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_Permissions`
--

DROP TABLE IF EXISTS `_Permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_Permissions` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `id_sup` int(4) NOT NULL,
  `idLab` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_Permissions`
--

LOCK TABLES `_Permissions` WRITE;
/*!40000 ALTER TABLE `_Permissions` DISABLE KEYS */;
INSERT INTO `_Permissions` VALUES (1,0,'WebCati',0),(2,0,'WebUsersPool',0),(3,1,'Survey',0),(4,3,'Web (www)',0),(5,3,'Telephone',0),(6,7,'Menu',2),(7,1,'Administration',1),(8,7,'Projects',3),(9,12,'Permissions',1),(10,3,'Capi',3),(11,0,'WebRecode',0),(12,0,'Tools',0),(13,0,'Options',0),(14,0,'Help',0),(15,7,'Manage Projects',0),(16,0,'Mystery',4),(17,16,'Mystery admin',1),(18,16,'Mystery client',2),(19,18,'Visits preview',1),(20,18,'Single report',2),(21,18,'Total report',3),(22,18,'Statistics',4),(23,18,'Info',8),(24,18,'Help',9),(25,23,'Comment',1),(26,19,'Show visits',1),(27,19,'Save to new visit group',2),(28,19,'Move to existing visit group',3),(29,19,'Make interview',4),(30,20,'Report',1),(31,20,'Total',2),(32,20,'Graph',3),(33,20,'Settings',4),(34,20,'Comment',5),(35,20,'Image',6),(36,21,'Total',1),(37,21,'Graph',2),(38,21,'Settings',3),(39,26,'Completed',1),(40,26,'Confirmed',2),(41,26,'Planed',3),(42,18,'Visit Groups',1),(43,42,'Show all groups',1),(44,42,'Show only groups',1),(45,22,'Project groups',1),(46,45,'Show all groups',1),(47,45,'Show only groups',2),(48,19,'Edit Fields',4),(49,48,'User Id',1),(50,48,'Date/Time',2),(51,19,'Reset Interview',0);
/*!40000 ALTER TABLE `_Permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_UserPermissions`
--

DROP TABLE IF EXISTS `_UserPermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_UserPermissions` (
  `id_user` int(11) NOT NULL,
  `id_permission` int(11) NOT NULL,
  UNIQUE KEY `permission_id` (`id_user`,`id_permission`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_UserPermissions`
--

LOCK TABLES `_UserPermissions` WRITE;
/*!40000 ALTER TABLE `_UserPermissions` DISABLE KEYS */;
INSERT INTO `_UserPermissions` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(1,13),(1,14),(1,15),(1,16),(1,17),(1,18),(1,19),(1,20),(1,21),(1,22),(1,23),(1,24),(1,25),(1,26),(1,27),(1,28),(1,29),(1,30),(1,31),(1,32),(1,33),(1,34),(1,35),(1,36),(1,37),(1,38),(1,39),(1,40),(1,41),(1,42),(1,43),(1,44),(1,45),(1,46),(1,47),(1,48),(1,49),(1,50),(1,51),(2,1),(2,2),(2,3),(2,4),(2,5),(2,6),(2,7),(2,8),(2,9),(2,10),(2,11),(2,12),(2,13),(2,14),(2,15),(2,16),(2,17),(2,18),(2,19),(2,20),(2,21),(2,22),(2,23),(2,24),(2,25),(2,26),(2,27),(2,28),(2,29),(2,30),(2,31),(2,32),(2,33),(2,34),(2,35),(2,36),(2,37),(2,38),(2,39),(2,40),(2,41),(2,42),(2,43),(2,44),(2,45),(2,46),(2,47),(2,48),(2,49),(2,50),(2,51),(3,1),(3,2),(3,3),(3,4),(3,5),(3,6),(3,7),(3,8),(3,9),(3,10),(3,11),(3,12),(3,13),(3,14),(3,15),(3,16),(3,17),(3,18),(3,19),(3,20),(3,21),(3,22),(3,23),(3,24),(3,25),(3,26),(3,27),(3,28),(3,29),(3,30),(3,31),(3,32),(3,33),(3,34),(3,35),(3,36),(3,37),(3,38),(3,39),(3,40),(3,41),(3,42),(3,43),(3,44),(3,45),(3,46),(3,47),(3,48),(3,49),(3,50),(3,51);
/*!40000 ALTER TABLE `_UserPermissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_WarpitClipboard`
--

DROP TABLE IF EXISTS `_WarpitClipboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_WarpitClipboard` (
  `id_user` int(11) NOT NULL,
  `id_type` int(11) NOT NULL,
  `typeDef` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `clipData` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id_user`,`id_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_WarpitClipboard`
--

LOCK TABLES `_WarpitClipboard` WRITE;
/*!40000 ALTER TABLE `_WarpitClipboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `_WarpitClipboard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_WarpitConfig`
--

DROP TABLE IF EXISTS `_WarpitConfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_WarpitConfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prefix` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cName` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cValue` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix_cName` (`prefix`,`cName`),
  KEY `prefix` (`prefix`(3))
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_WarpitConfig`
--

LOCK TABLES `_WarpitConfig` WRITE;
/*!40000 ALTER TABLE `_WarpitConfig` DISABLE KEYS */;
INSERT INTO `_WarpitConfig` VALUES (26,'asterisk_dialing','PredictiveExt','700'),(6,'asterisk_dialing','callerID','11111111'),(5,'asterisk_dialing','context','local'),(4,'asterisk_dialing','asterisk_port','5038'),(3,'asterisk_dialing','asterisk_ip','pbx.rmplus.si'),(2,'asterisk_dialing','asterisk_password',''),(1,'asterisk_dialing','asterisk_username',''),(105,'aufo_fill_questionnair','max_filter_tries','3'),(104,'aufo_fill_questionnair','max_question_repete','3'),(59,'backup','index','1'),(58,'backup','log','1'),(57,'backup','engine','1'),(56,'backup','structure','1'),(88,'call_center','dial_prefix',''),(87,'call_center','iframe_tel_dial_server',''),(80,'call_center','iframe_tel_dial','0'),(71,'call_center','available_SIPphone_numbers','81,82'),(69,'call_center','video_enabled','0'),(68,'call_center','auto_answer','0'),(66,'call_center','enable_rtcweb_breaker','1'),(65,'call_center','sip_outbound_proxy','udp://sorspbx.rmplus.si:5060'),(64,'call_center','web_socket_server','ws://sorspbx.rmplus.si:8088/ws'),(63,'call_center','realm','sorspbx.rmplus.si'),(101,'capi','capi_gps_interval','60'),(82,'capi','client-machine-id','SOLVEX1'),(31,'capi','capi_client_version','1'),(30,'capi','instruction-link','http://'),(29,'capi','default-language','0'),(73,'capi_html','menuPosition','right'),(84,'capi-server','default-download-allow','1'),(83,'capi-server','allow-register-machine-id','1'),(13,'database','table_warpit_webrecode','Warpit1705_Webrecode'),(12,'database','table_warpit_liveupdate','Warpit1705_Webcati_liveupdate'),(11,'database','table_warpit_webhelp','Warpit1705_Webhelp'),(10,'database','table_warpit_userspool','Warpit1705_Webuserspool'),(9,'database','table_warpit_webcati_base','Warpit1705_Webcati_base'),(8,'database','table_warpit_webcati','Warpit1705_Webcati'),(7,'database','table_warpit_main','Warpit1705'),(17,'emails','admin_email','admin@rmplus.si'),(55,'import_option','tmp_folder','/tmp/'),(54,'import_option','cp_default','utf8'),(53,'import_option','method',''),(102,'incentive','default_state_id','7'),(93,'incentive','payout_purpose_id','15'),(92,'incentive','questioner_purpose_id','6'),(90,'login','show_extension','0'),(89,'login','show_remember','0'),(18,'multilanguage','id_default_language','46'),(86,'mystery','default-language','91'),(85,'mystery','database','Warpit1705_mystery'),(81,'Nfield','enable','0'),(91,'paths','usr_methods_custom','survey/users_methods_custom.php'),(50,'paths','live_update_zip_files','/var/www/virtual/arm-1qawdfvbgyhnjiol0iju/webProjectsLiveUpdate/'),(49,'paths','warpit_userDefine',''),(48,'paths','phpMyAdmin_www',''),(33,'paths','live_update_locale_container',''),(32,'paths','live_update_zip_files_remote',''),(28,'paths','live_update_www',''),(27,'paths','warpit_webprojects_www','https://{$_SERVER[\'SERVER_NAME\']}:{$_SERVER[\'SERVER_PORT\']}/webProjects'),(19,'paths','redirectModul_www','https://{$_SERVER[\'SERVER_NAME\']}:{$_SERVER[\'SERVER_PORT\']}/webuserspool/_redirect/'),(16,'paths','warpit_absolute','/var/www/virtual/arm-1qawdfvbgyhnjiol0iju/warpit/'),(15,'paths','warpit_webprojects','/var/www/virtual/arm-1qawdfvbgyhnjiol0iju/webProjects'),(14,'paths','warpit_www','https://{$_SERVER[\'SERVER_NAME\']}:{$_SERVER[\'SERVER_PORT\']}/'),(67,'sample_option','delay_day_time','60'),(95,'startup_settings','answers_editor_type','2'),(94,'startup_settings','show_tip_of_the_day','0'),(72,'statistics','interviewer_addon',''),(78,'survey','custom_code',''),(77,'survey','show_test_check','0'),(74,'survey','multiresponse_default_fill','0'),(70,'survey','record_owner','last'),(52,'survey','survey_codepage','utf-8'),(51,'survey','survey_title',''),(76,'tgi','export_vars_pool',''),(75,'tgi','export_vars',''),(36,'update','warpit_license_key','test-123456789-1'),(35,'update','warpit_server_www','http://support.rmplus.si'),(34,'update','warpit_version','2.40.20120603'),(25,'versionControl','version','82'),(103,'webcati','end_data_default_interval','P1Y'),(100,'webcati','codemirror_version','1'),(99,'webcati','select_sample_more_then_once','1'),(98,'webcati','allow_listening_question_value','1'),(97,'webcati','default_lock_app_to_user','1'),(96,'webcati','premission_for_interviewing','1'),(24,'webcati_old','RM_cati_base','RM_cati_base'),(23,'webcati_old','RM_cati','RM_cati'),(22,'webcati_old','password',''),(21,'webcati_old','username',''),(20,'webcati_old','server',''),(79,'webuserspool','dontSendCondition',''),(106,'webuserspool','appointments_group','2'),(107,'webuserspool','appointments_template','1'),(108,'survey','check_quota_on_all_questions','0'),(109,'capi','capi_show_config','1'),(110,'dailer_settings','max_number_of_indexes_to_check','3'),(111,'webcati_import','show_ans_label','1'),(112,'webcati_import','show_question_name','1'),(113,'capi','ssl_verify','1'),(114,'webuserspool','timeBetweenSending','1'),(115,'versionControl','statview_version','1'),(116,'statview_warpitServer2','database',''),(117,'statview_warpitServer2','username',''),(118,'statview_warpitServer2','password',''),(119,'statview_warpitServer2','host',''),(120,'database','table_warpit_statview','Warpit1705_Statview'),(121,'webcati','show_only_app','0'),(122,'paths','live_update_recieve_script','_liveUpdate/Recieve-XML-data.php'),(123,'paths','live_update_version_script','_liveUpdate/Version-control.php'),(124,'capi','show_quota_record_value_index','1'),(125,'incentive','points_expiration','5184000'),(126,'paths','warpit_external_www',''),(127,'paths','redirectModul_external_www',''),(128,'survey','encryptionKey',''),(129,'live_watch','server_php',''),(130,'live_watch','tmp_path',''),(131,'live_watch','websockets_server_address',''),(132,'webcati','interviewer_enable_id_editing','0'),(133,'webcati','default_hide_start_end','0,0'),(134,'asterisk_dialing','context_predictive',''),(135,'survey','show_search_bar','1'),(136,'webcati','default_quota_show_interviewer','0'),(137,'export_option','cp_default','utf-8'),(138,'capi','connection_timeout','241'),(139,'capi','client_log_date_format','Ymd_his'),(140,'capi','client_log_path','capi/_log/'),(141,'live_watch','show_log','0'),(142,'security','max_login_attempts','10'),(143,'password_options','min_length','6'),(144,'password_options','include_number','0'),(145,'password_options','include_special_char','0'),(146,'password_options','include_letter','0'),(147,'password_options','include_letter_lower','0'),(148,'password_options','include_letter_upper','0');
/*!40000 ALTER TABLE `_WarpitConfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languagePack`
--

DROP TABLE IF EXISTS `_languagePack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languagePack` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_programme` tinyint(4) NOT NULL,
  `id_language` mediumint(9) NOT NULL,
  `sub_page` varchar(25) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `translate_key` varchar(25) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `translate_text` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_select` (`id_programme`,`id_language`,`sub_page`,`translate_key`)
) ENGINE=MyISAM AUTO_INCREMENT=308 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languagePack`
--

LOCK TABLES `_languagePack` WRITE;
/*!40000 ALTER TABLE `_languagePack` DISABLE KEYS */;
INSERT INTO `_languagePack` VALUES (1,2,0,'capi','instruction','Instruction'),(2,2,0,'capi','start-new','Start New'),(3,2,0,'capi','test-interview','Test Interview'),(4,2,0,'capi','appointments','Appointments'),(5,2,0,'capi','projects','Projects'),(6,2,0,'capi','live-update','Live Update'),(7,2,0,'capi','login-user','Login User'),(8,2,0,'capi','login-time','Login time'),(9,2,0,'capi','interview','Interview'),(10,2,0,'capi','interrupt-interview','Interrupt Interview'),(11,2,0,'capi','interrupt-are-sure','Interrupt : Are you sure'),(12,2,0,'capi','make-appointment','Make appointment'),(13,2,0,'capi','appointment','Appointment'),(14,2,0,'capi','sure-make-appointment','Are you sure to make appointment'),(15,2,0,'capi','project-status','Project status'),(16,2,0,'capi','no-project-is-selected','No project is selected'),(17,2,0,'capi','refresh','Refresh'),(18,2,0,'capi','date-time','Date - Time'),(19,2,0,'capi','contact-person','Contact person'),(20,2,0,'capi','comment','Comment'),(21,2,0,'capi','save','Save'),(22,2,2,'capi','instruction','Instruksioni'),(23,2,2,'capi','start-new','Fillo nje te Re'),(24,2,2,'capi','test-interview','Test Interviste'),(25,2,2,'capi','appointments','Takime'),(26,2,2,'capi','projects','Projekte'),(27,2,2,'capi','live-update','Perditesim'),(28,2,2,'capi','login-user','Perdoruesi'),(29,2,2,'capi','login-time','Koha '),(30,2,2,'capi','interview','Interviste'),(31,2,2,'capi','interrupt-interview','Nderprerje e Intervistes'),(32,2,2,'capi','interrupt-are-sure','Nderprerje : A jeni I sigurte?'),(33,2,2,'capi','make-appointment','Lenie takimi'),(34,2,2,'capi','appointment','Takim'),(35,2,2,'capi','sure-make-appointment','Jeni I sigurte qe deshironi te lini takim'),(36,2,2,'capi','project-status','Statusi I Projektit'),(37,2,2,'capi','no-project-is-selected','Asnje projekt I zgjedhur/selektuar'),(38,2,2,'capi','refresh','Rifreskim'),(39,2,2,'capi','date-time','Data - Ora'),(40,2,2,'capi','contact-person','Personi I kontaktit'),(41,2,2,'capi','comment','Komente'),(42,2,2,'capi','save','Ruaj'),(43,2,123,'capi','instruction','Upustvo'),(44,2,123,'capi','start-new','Započeti novu anketu'),(45,2,123,'capi','test-interview','Testirati anketu'),(46,2,123,'capi','appointments','Termini'),(47,2,123,'capi','projects','Projekti'),(48,2,123,'capi','live-update','Live Update'),(49,2,123,'capi','login-user','Korisnik'),(50,2,123,'capi','login-time','Vrijeme ulaska'),(51,2,123,'capi','interview','Anketa'),(52,2,123,'capi','interrupt-interview','Prekinuti anketu'),(53,2,123,'capi','interrupt-are-sure','Prekinuti: Da li ste sigurni?'),(54,2,123,'capi','make-appointment','Zakazati termin'),(55,2,123,'capi','appointment','Termin'),(56,2,123,'capi','sure-make-appointment','Da li ste sigurni da želite zakazati termin?'),(57,2,123,'capi','project-status','Status projekta'),(58,2,123,'capi','no-project-is-selected','Niti jedan projekat nije selektiran'),(59,2,123,'capi','refresh','Osvježiti'),(60,2,123,'capi','date-time','Datum - Vrijeme'),(61,2,123,'capi','contact-person','Kontakt osoba'),(62,2,123,'capi','comment','Komentar'),(63,2,123,'capi','save','Spasiti'),(64,2,30,'capi','instruction','Upute'),(65,2,30,'capi','start-new','Pokreni novu anketu'),(66,2,30,'capi','test-interview','Testna anketa'),(67,2,30,'capi','appointments','Dogovori'),(68,2,30,'capi','projects','Projekti'),(69,2,30,'capi','live-update','Ažuriranje'),(70,2,30,'capi','login-user','Prijavljeni korisnik'),(71,2,30,'capi','login-time','Vrijeme prijave'),(72,2,30,'capi','interview','Anketa'),(73,2,30,'capi','interrupt-interview','Prekinite anketu'),(74,2,30,'capi','interrupt-are-sure','Prekinuti: da li ste sigurni?'),(75,2,30,'capi','make-appointment','Napravi dogovor'),(76,2,30,'capi','appointment','Dogovor'),(77,2,30,'capi','sure-make-appointment','Da li zaista želite napraviti dogovor?'),(78,2,30,'capi','project-status','Status projekta'),(79,2,30,'capi','no-project-is-selected','Projekt nije odabran'),(80,2,30,'capi','refresh','Osvježi'),(81,2,30,'capi','date-time','Datum - Vrijeme'),(82,2,30,'capi','contact-person','Kontakt osoba'),(83,2,30,'capi','comment','Komentar'),(84,2,30,'capi','save','Snimi'),(85,2,124,'capi','instruction','Инструкции'),(86,2,124,'capi','start-new','Отпочни ново'),(87,2,124,'capi','test-interview','Тест интервју'),(88,2,124,'capi','appointments','Закажани'),(89,2,124,'capi','projects','Проекти'),(90,2,124,'capi','live-update','Ажурирање'),(91,2,124,'capi','login-user','Корисничко име'),(92,2,124,'capi','login-time','Време на логирање'),(93,2,124,'capi','interview','Интервју'),(94,2,124,'capi','interrupt-interview','Прекини интервју'),(95,2,124,'capi','interrupt-are-sure','Прекин: Дали сте сигурни'),(96,2,124,'capi','make-appointment','Закажи интервју'),(97,2,124,'capi','appointment','Закажано'),(98,2,124,'capi','sure-make-appointment','Дали сте сигурни дека сакате да закажете'),(99,2,124,'capi','project-status','Статус на проект'),(100,2,124,'capi','no-project-is-selected','Не е одбран проект'),(101,2,124,'capi','refresh','Освежи'),(102,2,124,'capi','date-time','Датум - Време'),(103,2,124,'capi','contact-person','Лице за контакт'),(104,2,124,'capi','comment','Коментар'),(105,2,124,'capi','save','Зачувај'),(106,2,91,'capi','instruction','Navodila'),(107,2,91,'capi','start-new','Nov vnos'),(108,2,91,'capi','test-interview','Testna anketa'),(109,2,91,'capi','appointments','Dogovor'),(110,2,91,'capi','projects','Projekti'),(111,2,91,'capi','live-update','Prenesi podatke'),(112,2,91,'capi','login-user','Uporabnik'),(113,2,91,'capi','login-time','Čas prijave'),(114,2,91,'capi','interview','Anketa'),(115,2,91,'capi','interrupt-interview','Prekini anketo'),(116,2,91,'capi','interrupt-are-sure','Prekini anketo: Ste prepričani?'),(117,2,91,'capi','make-appointment','Naredi dogovor'),(118,2,91,'capi','appointment','dogovor'),(119,2,91,'capi','sure-make-appointment','Ste prepričani da bi naredili dogovor?'),(120,2,91,'capi','project-status','Status projekta'),(121,2,91,'capi','no-project-is-selected','Izbran ni noben projekt'),(122,2,91,'capi','refresh','Osveži'),(123,2,91,'capi','date-time','Datum-čas'),(124,2,91,'capi','contact-person','kontaktna oseba'),(125,2,91,'capi','comment','Komentar'),(126,2,91,'capi','save','Shrani'),(127,2,89,'capi','instruction','Upustvo'),(128,2,89,'capi','start-new','Pokreni novu anketu'),(129,2,89,'capi','test-interview','Test anketa'),(130,2,89,'capi','appointments','Zakazano'),(131,2,89,'capi','projects','Projekti'),(132,2,89,'capi','live-update','Ažuriranje'),(133,2,89,'capi','login-user','Korisnik'),(134,2,89,'capi','login-time','Vreme prijave'),(135,2,89,'capi','interview','Anketa'),(136,2,89,'capi','interrupt-interview','Prekinuti anketu'),(137,2,89,'capi','interrupt-are-sure','Prekinuti: Da li ste sigurni?'),(138,2,89,'capi','make-appointment','Zakazati termin'),(139,2,89,'capi','appointment','Termin'),(140,2,89,'capi','sure-make-appointment','Da li ste sigurni da želite zakazati termin?'),(141,2,89,'capi','project-status','Status projekta'),(142,2,89,'capi','no-project-is-selected','Nijedan projekat nije izabran'),(143,2,89,'capi','refresh','Osveži'),(144,2,89,'capi','date-time','Datum - Vreme'),(145,2,89,'capi','contact-person','Kontakt osoba'),(146,2,89,'capi','comment','Komentar'),(147,2,89,'capi','save','Snimi'),(249,1,46,'interviewer-statistics','all_success','Number of all successful interviews'),(250,1,46,'interviewer-statistics','all_test','Number of all test interviews'),(251,1,46,'interviewer-statistics','all_unsuccess','Number of all unsuccessful calls'),(255,1,46,'interviewer-statistics','appointments','Number of appointment calls'),(260,1,46,'interviewer-statistics','average_complete','Average time spent for complete interview (minutes)'),(252,1,46,'interviewer-statistics','busy','Number of busy calls'),(257,1,46,'interviewer-statistics','interviewer_error','Number of interviewer error calls (browser shutdown, refresh, double-click, ...)'),(259,1,46,'interviewer-statistics','max_length','Maximum interviewing length for complete interview (minutes)'),(254,1,46,'interviewer-statistics','middle_unsuccess','Number of unsuccessful calls in the middle of the interview'),(258,1,46,'interviewer-statistics','min_length','Minumum interviewing length for complete interview (minutes)'),(253,1,46,'interviewer-statistics','not_available','Number of unavailable calls (no one pick up the phone)'),(256,1,46,'interviewer-statistics','quota_unsuccess','Number of quota unsuccessful calls'),(262,1,46,'interviewer-statistics','sum_all','Total time spent for all calls (minutes)'),(261,1,46,'interviewer-statistics','sum_completed','Comulative time spent for all completed interviews (minutes)'),(263,1,60,'interviewer-statistics','all_success','Anzahl aller erfolgreichen Interviews'),(264,1,60,'interviewer-statistics','all_test','Anzahl aller Test-Interviews'),(265,1,60,'interviewer-statistics','all_unsuccess','Anzahl aller erfolglosen Anrufe'),(269,1,60,'interviewer-statistics','appointments','Anzahl der vereinbarter Termin Anrufe'),(274,1,60,'interviewer-statistics','average_complete','Durchschnittliche Zeit für die komplette Interview (in Minuten)'),(266,1,60,'interviewer-statistics','busy','Anzahl der Anrufe wo besetzt war'),(271,1,60,'interviewer-statistics','interviewer_error','Anzahl Fehlerheften Anrufe durch den Interviewer (Browser Schließung, refresh, doppelklick…)'),(273,1,60,'interviewer-statistics','max_length','Maximale Länge für ein komplettes Interview (Minuten)'),(268,1,60,'interviewer-statistics','middle_unsuccess','Anzahl der erfolglosen Anrufe in der Mitte des interview'),(272,1,60,'interviewer-statistics','min_length','Minimale Länge für ein komplettes Interview (Minuten)'),(267,1,60,'interviewer-statistics','not_available','Anzahl der nicht verfügbaren Anrufe (niemand geht ans Telefon)'),(270,1,60,'interviewer-statistics','quota_unsuccess','Anzahl der erfolglosen Anrufe wegen der Quote'),(276,1,60,'interviewer-statistics','sum_all','Gesamte verbrauchte Zeit für alle Anrufe (in Minuten)'),(275,1,60,'interviewer-statistics','sum_completed','Gesamte Zeit verbraucht für alle komplette Interviews (in Minuten)'),(277,2,46,'call_center','redirect','Redirect'),(278,2,46,'call_center','login-time','Login time'),(279,2,46,'call_center','full-screen','Full screen'),(280,2,46,'call_center','logout','Logout'),(281,2,46,'call_center','active-tel-num','Ongoing call in/out'),(282,2,46,'call_center','call','Call'),(283,2,46,'call_center','end-call','End call'),(284,2,46,'call_center','record','Record'),(285,2,46,'call_center','active-projects','Active projects'),(286,2,46,'call_center','call-list','Call list'),(287,2,46,'call_center','call-control-panel','WebSoft Phone'),(288,2,46,'call_center','questionarie','Questionarie'),(289,2,46,'call_center','incoming-call','Accept IN'),(290,2,46,'call_center','outgoing-call','Accept OUT'),(291,2,46,'call_center','project-name','Project name'),(292,2,46,'call_center','customer-name','Customer name'),(293,2,46,'call_center','tel-number','Number'),(294,2,46,'call_center','last-call','Last call'),(295,2,46,'call_center','direction','Direction'),(296,2,46,'call_center','incoming','Incoming'),(297,2,46,'call_center','outgoing','Outgoing'),(298,2,46,'call_center','IE-full-screen-err','You are using a browser, which does not support this function. Please, press \\\'F11\\\' button on your keyboard instead.'),(299,2,46,'call_center','startAcceptingCalls','Connect'),(300,2,46,'call_center','pauseAcceptingCalls','Pause'),(301,2,46,'call_center','stopRecording','Stop'),(302,2,46,'call_center','login-user','Login user'),(303,2,46,'call_center','enter-valid-phone-number','Please, enter a valid phone number'),(304,2,0,'capi','sample-points','Sample points'),(305,1,46,'interviewer-statistics','total_time','Response rate'),(306,1,46,'interviewer-statistics','sum_real','Total time spent for all real calls (minutes)'),(307,1,46,'interviewer-statistics','sum_test','Total time spent for test interviews (minutes)');
/*!40000 ALTER TABLE `_languagePack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languagePackProgramm`
--

DROP TABLE IF EXISTS `_languagePackProgramm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languagePackProgramm` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_programme` tinyint(3) NOT NULL,
  `text` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_programme` (`id_programme`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languagePackProgramm`
--

LOCK TABLES `_languagePackProgramm` WRITE;
/*!40000 ALTER TABLE `_languagePackProgramm` DISABLE KEYS */;
INSERT INTO `_languagePackProgramm` VALUES (1,1,'warpit admin'),(2,2,'client portals');
/*!40000 ALTER TABLE `_languagePackProgramm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_session_variable`
--

DROP TABLE IF EXISTS `_session_variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_session_variable` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `id_session` int(6) NOT NULL,
  `variable_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_id` (`id_session`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `_systemVariables`
--

DROP TABLE IF EXISTS `_systemVariables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_systemVariables` (
  `varName` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `varValue` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `area` tinyint(3) unsigned NOT NULL,
  UNIQUE KEY `varName` (`varName`),
  KEY `area` (`area`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_systemVariables`
--

LOCK TABLES `_systemVariables` WRITE;
/*!40000 ALTER TABLE `_systemVariables` DISABLE KEYS */;
INSERT INTO `_systemVariables` VALUES ('TMP_PATH_ON_DISK','/tmp/',1);
/*!40000 ALTER TABLE `_systemVariables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user`
--

DROP TABLE IF EXISTS `_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `permissionGroup` smallint(3) NOT NULL,
  `username` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `Firstname` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `Surname` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `language` tinyint(2) NOT NULL,
  `debugMode` tinyint(1) NOT NULL,
  `mail_account_default` int(11) NOT NULL,
  `lng_admin` int(11) NOT NULL,
  `view` tinyint(4) NOT NULL DEFAULT '1',
  `SIPPhoneID` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `SIPPass` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme` tinyint(1) NOT NULL,
  `sessionTimeout` int(11) DEFAULT '6000',
  `login_attempts` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`,`password`),
  KEY `SIPPhoneID` (`SIPPhoneID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user`
--

LOCK TABLES `_user` WRITE;
/*!40000 ALTER TABLE `_user` DISABLE KEYS */;
INSERT INTO `_user` VALUES (1,1,'admin','$2y$10$8Bw4C35FiCBp5cB8KuFk5eqdneYEfGqf4SmKbHVKyZVljCGdrBtMm','Administrator','','',46,0,0,46,1,'0','',0,6000,0),(3,1,'tanis','$2y$10$m8tXOBPfNdAflEacF6.ftOZLn4KdKI/D.i7jJ1IoCwX4BRMgikL1G','Tanis','','',91,0,0,46,1,NULL,NULL,0,6000,0);
/*!40000 ALTER TABLE `_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user_session`
--

DROP TABLE IF EXISTS `_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user_session` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `id_ascii_session` char(36) COLLATE utf8_unicode_ci NOT NULL,
  `logged_in` tinyint(1) NOT NULL DEFAULT '0',
  `id_user` int(4) NOT NULL DEFAULT '0',
  `user_type` tinyint(4) NOT NULL,
  `last_impression` datetime NOT NULL,
  `created` datetime NOT NULL,
  `logout` datetime NOT NULL,
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ascii_session_id` (`id_ascii_session`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user_session`
--

LOCK TABLES `_user_session` WRITE;
/*!40000 ALTER TABLE `_user_session` DISABLE KEYS */;
INSERT INTO `_user_session` VALUES (1,'76bs0plhtfcbkmalb85bj0b6d7',1,1,0,'2016-01-06 12:33:03','2016-01-06 11:35:00','0000-00-00 00:00:00',''),(2,'4q4oaova1s3hoves7bluetcmb0',0,0,0,'2016-01-06 11:35:08','2016-01-06 11:35:08','2016-01-06 11:35:08',''),(3,'aaea8mplpk9juu9vstfvf422c2',0,2,1,'2016-01-06 11:36:34','2016-01-06 11:35:15','2016-01-06 11:36:34',''),(4,'hm9nepn62o7a0plhqkiofd2ud2',0,1,1,'2016-01-06 11:36:49','2016-01-06 11:36:39','2016-01-06 11:36:49',''),(5,'qt5nt6uttl5r3us9u6jt8meb52',0,0,0,'2016-01-06 11:37:00','2016-01-06 11:37:00','2016-01-06 11:37:00',''),(6,'9ojc2ia75rptvf8l01p0ptpt90',0,0,0,'2016-01-06 11:37:01','2016-01-06 11:37:01','2016-01-06 11:37:01',''),(7,'18tpc9pcvb7s5ppf8p8tstrhp5',0,1,1,'2016-01-06 11:37:17','2016-01-06 11:37:09','2016-01-06 11:37:17',''),(8,'b2ueqoupi2viaa2ic0fb4pnu41',0,1,1,'2016-01-06 11:58:07','2016-01-06 11:37:22','2016-01-06 11:58:07',''),(9,'8l1r7k4p1bfuek4d50p7gve361',0,2,1,'2016-01-06 12:08:52','2016-01-06 11:58:16','2016-01-06 12:08:52',''),(10,'cgp2if5lru914cem0jad8rmok2',0,0,0,'2016-01-06 12:05:25','2016-01-06 12:05:25','2016-01-06 12:05:25',''),(11,'67smgm8vt0cav5075p1qtkk303',0,1,1,'2016-01-06 12:15:53','2016-01-06 12:05:28','2016-01-06 12:15:53',''),(12,'etps32j232uqlsargdpceqnud2',0,2,1,'2016-01-06 12:09:13','2016-01-06 12:08:58','2016-01-06 12:09:13',''),(13,'nb5asc4abkinqm2uicn5lbrv04',0,1,0,'2016-01-06 12:11:24','2016-01-06 12:09:16','2016-01-06 12:11:24',''),(14,'mfpp4e56g7aujaljuptb8v6m87',0,1,1,'2016-01-06 12:41:54','2016-01-06 12:11:32','2016-01-06 12:41:54',''),(15,'h5uegucc8ib8qg7quvdqe59ol4',0,1,0,'2016-01-06 12:24:35','2016-01-06 12:15:58','2016-01-06 12:24:35',''),(16,'uh6038om83tugb24hhg37be1d2',0,1,1,'2016-01-06 12:31:36','2016-01-06 12:26:04','2016-01-06 12:31:36',''),(17,'5bhnnq89n974fou2s4loec8kj0',0,2,1,'2016-01-06 12:32:48','2016-01-06 12:31:40','2016-01-06 12:32:48',''),(18,'0dmecbpofk12jo3jksi96f61r3',0,1,0,'2016-01-06 12:43:53','2016-01-06 12:42:04','2016-01-06 12:43:53',''),(19,'5apu6rl16gialo6p3f65rp5bu4',1,1,1,'2016-01-06 12:44:13','2016-01-06 12:43:58','0000-00-00 00:00:00',''),(20,'k5pkll44fengd9dtgmupr7t064',0,0,0,'2016-11-03 11:37:35','2016-11-03 11:37:35','2016-11-03 11:37:35',''),(21,'5qch0q075qbj6i6buv7gojit33',1,1,1,'2016-11-03 11:51:31','2016-11-03 11:37:40','0000-00-00 00:00:00',''),(22,'m6r9d5nrqd1cbdc7fb2gu5lps1',0,0,0,'2016-11-03 11:45:56','2016-11-03 11:45:56','2016-11-03 11:45:56',''),(23,'3l5alj83nthu2t7cm3p5rej0i7',0,3,1,'2016-11-03 11:50:44','2016-11-03 11:46:00','2016-11-03 11:50:44',''),(24,'q8cjhit7f1i7kevj3hhgim0n47',1,3,1,'2016-11-03 11:52:32','2016-11-03 11:50:49','0000-00-00 00:00:00',''),(25,'3a6jth6e1kjc9vlq37qdo1uqr7',0,0,0,'2016-11-04 06:26:33','2016-11-04 06:26:33','2016-11-04 06:26:33',''),(26,'vod0mtivc1e1tvf9ccq9j7bof0',1,1,1,'2016-11-04 06:26:37','2016-11-04 06:26:36','0000-00-00 00:00:00',''),(27,'apfm1iojsdish85g9fq7rkjma6',0,0,0,'2016-11-11 10:18:48','2016-11-11 10:18:48','2016-11-11 10:18:48',''),(28,'83qkr760v54in7voggnvn1pku5',1,1,1,'2016-11-11 10:19:03','2016-11-11 10:18:52','0000-00-00 00:00:00',''),(29,'61iu31nck7c2gtngjpgosqh1k4',0,1,1,'2017-05-03 10:17:29','2017-05-03 10:03:26','2017-05-03 10:17:29',''),(30,'ecnq83md0va5950uhavco7vnd4',1,1,1,'2017-05-03 10:36:13','2017-05-03 10:17:33','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user_tab_state`
--

DROP TABLE IF EXISTS `_user_tab_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user_tab_state` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(5) unsigned NOT NULL,
  `id_tab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `params` text COLLATE utf8_unicode_ci NOT NULL,
  `tab_parent` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `USER_TAB` (`id_user`,`id_tab`)
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user_tab_state`
--

LOCK TABLES `_user_tab_state` WRITE;
/*!40000 ALTER TABLE `_user_tab_state` DISABLE KEYS */;
INSERT INTO `_user_tab_state` VALUES (62,3,'webCatiUniqePanel','webcati/_forms/tree.groups.php','{\"treeName\":\"CatiMenu\",\"tree\":\"_ProgramMenu\",\"action\":\"add\",\"uniqueTabId\":\"webCatiUniqePanel\",\"uniqueTabUrl\":\"webcati/_forms/tree.groups.php\"}','mainTabPanel'),(39,1,'panelistsOverview','webuserspool/_forms/panelistsOverview/forms.panelistsOverview.php','{\"action\":\"add\",\"uniqueTabId\":\"panelistsOverview\",\"uniqueTabUrl\":\"webuserspool/_forms/panelistsOverview/forms.panelistsOverview.php\"}','mainTabPanel'),(64,3,'telNumberManagment','webcati/_forms/telNumberManagment/forms.telNumberManagment.php','{\"action\":\"add\",\"uniqueTabId\":\"telNumberManagment\",\"uniqueTabUrl\":\"webcati/_forms/telNumberManagment/forms.telNumberManagment.php\"}','mainTabPanel'),(66,1,'webCatiUniqePanel','webcati/_forms/tree.groups.php','{\"treeName\":\"CatiMenu\",\"tree\":\"_ProgramMenu\",\"action\":\"add\",\"uniqueTabId\":\"webCatiUniqePanel\",\"uniqueTabUrl\":\"webcati/_forms/tree.groups.php\"}','mainTabPanel'),(63,3,'webUserspoolUniqePanel','webuserspool/_forms/tree.groups.php','{\"treeName\":\"PoolMenu\",\"tree\":\"_ProgramMenu\",\"action\":\"add\",\"uniqueTabId\":\"webUserspoolUniqePanel\",\"uniqueTabUrl\":\"webuserspool/_forms/tree.groups.php\"}','mainTabPanel'),(60,3,'statviewUniqePanel','statview/_forms/tree.groups.php','{\"treeName\":\"StatviewMenu\",\"tree\":\"_ProgramMenu\",\"action\":\"add\",\"uniqueTabId\":\"statviewUniqePanel\",\"uniqueTabUrl\":\"statview/_forms/tree.groups.php\"}','mainTabPanel'),(70,1,'WarpitPermissionPanelUniqe','_forms/forms.permissions.php','{\"action\":\"add\",\"uniqueTabId\":\"WarpitPermissionPanelUniqe\",\"uniqueTabUrl\":\"_forms/forms.permissions.php\"}','mainTabPanel'),(71,1,'permissionTreeGrid_1_user','_forms/forms.permissionTreeGrid.php','{\"isUser\":\"true\",\"id\":\"1\",\"name\":\"Administrator \",\"action\":\"add\",\"uniqueTabId\":\"permissionTreeGrid_1_user\",\"uniqueTabUrl\":\"_forms/forms.permissionTreeGrid.php\"}','mainTabPanel');
/*!40000 ALTER TABLE `_user_tab_state` ENABLE KEYS */;
UNLOCK TABLES;
