<?php

class WebPoints
{
    private $db;
    
    private $pointsTable;
    
    private $purposeTable;
    
    public function __construct($db)
    {
        $this->db = $db;
        //TODO popravi v pravilno verzijo tabele
        $this->pointsTable = DB_WARPIT_WEBCATI_BASE . "._wwwPoints_newVersion";
        $this->purposeTable = DB_WARPIT_WEBCATI_BASE . "._wwwPurpose";
        
    }
    
    private function returnResults($sql, $results = null, $json = null)
    {
        if(!$res = $this->db->SQLexecute($sql))
            die($this->db->JsonError());
        
        $rows = array();
        while($row = $this->db->fetchAssoc($res))
            $rows[] = $row;
        
        $rtnData['success'] = TRUE;
        $rtnData['STATMENT'] = $sql;
        $rtnData['results'] = $results;
        $rtnData['rows'] = $rows;
        if($json)
            return json_encode($rtnData);
        else 
            return $rtnData;            
    }
    
    private function getNumResults($sql)
    {
        if(!$rsCount = $this->db->SQLexecute($sql))
            return false; 

        return $this->db->NumRows($rsCount);
    }
    
    private function selectCoupons($columns, $where, $json)
    {
        $sql = "SELECT " . $columns ."
                FROM " . DB_WARPIT_USERSPOOL . "._IncentiveCoupons AS a" . $where;
                
        return $this->returnResults($sql, null, $json);
    }
    
    public function getUsersWithPoints($where=null, $limit = null)
    {
        $sql = "SELECT * FROM(SELECT a.email, a.id, SUM(b.webPoints * c.negative) as points 
                            FROM " . DB_WARPIT_USERSPOOL . "._Interviewer AS a 
                            JOIN " . $this->pointsTable . " AS b ON a.id=b.id_user 
                            LEFT JOIN _wwwPurpose AS c ON b.id_purpose = c.id WHERE b.deleted = 0 GROUP BY a.email) as a";
                            
                
        if($where)
            $sql .= " WHERE " . $where;
        
        $results = $this->getNumResults($sql);
        if(strlen($limit) > 0)
            $sql .= $limit;
        
        return $this->returnResults($sql, $results, TRUE);
        
    }
    
    public function getUsersWithoutPoints($where=null, $limit=null, $default_state_id = 7)
    {
        $sql = "SELECT * FROM (SELECT a.id, a.email, 0 AS points, b.webPoints
                    FROM " . DB_WARPIT_USERSPOOL . "._Interviewer AS a
                    LEFT JOIN " . $this->pointsTable . " AS b ON a.id = b.id_user
                    WHERE (
                        id_purpose <> " . intval($default_state_id) . "
                        OR b.id IS NULL
                    )
                    GROUP BY a.email) as a";
                
        if($where)
            $sql .= " WHERE " . $where;
            
        $results = $this->getNumResults($sql);
        if(strlen($limit) > 0)
            $sql .= $limit;
        
        return $this->returnResults($sql, $results, TRUE);      
    }
    
    public function getPointsByUserId($userId)
    {
        
        // prvi sql je bil namenjen izračunu točk za star sistem. Uporabljal se je pri pošiljanju zbranih točk uporabnika  preko emaila.
       // $sql = "SELECT SUM(webPoints) as points FROM Warpit_Webcati_base._wwwPoints WHERE id_user = " . intval($userId) . " AND deleted = 0";
        $sql = "SELECT a.id_user, SUM(a.webPoints * b.negative) as points
                FROM " . $this->pointsTable . " as a  
                LEFT JOIN " . $this->purposeTable . " as b
                ON a.id_purpose = b.id
                WHERE a.deleted = 0 and a.id_user = " . intval($userId);
        if(!$res = $this->db->SQLexecute($sql))
            die($this->db->JsonError());
        $row = $this->db->fetchAssoc($res);
        
        return intval($row['points']);
    }
    
    public function getPointsReport($userId)
    {
        $sql = "SELECT a.id as id, a.webPoints * b.negative as points, b.label, a.modificationDate, c.proj_name FROM " . $this->pointsTable . " AS a 
                LEFT JOIN " . $this->purposeTable . " AS b ON a.id_purpose = b.id
                LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._Projects AS c ON a.id_project = c.id
                WHERE a.id_user = " . $userId . " AND a.deleted = 0";
                
        return $this->returnResults($sql, null, TRUE);
    }
    
    public function recalculatePointsForProject($id_project)
    {
        $sql = "SELECT proj_name FROM  ".DB_WARPIT_WEBCATI_BASE."._Projects WHERE id = " . $id_project;
        $res = $this->db->SQLexecute($sql);
        $zad = $this->db->fetchAssoc($res);
        $projname = $zad['proj_name'];
        
        $sql = "DELETE FROM " . $this->pointsTable . "  WHERE id_project = " . $id_project;
        $this->db->SQLexecute($sql);
        
        $sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE."._wwwPointsStructure WHERE id_project = " . $id_project . ". AND enabled = 1 ORDER BY priority";
        $webPoints = $this->db->SQLexecute($sql);
        
        while($wpRow = $this->db->fetchAssoc($webPoints))
        {
            $points = $wpRow['setpoints'];
            $cnd = $wpRow['sql_condition'];
            
            //TODO move hardcoded id_purpose to config
            $sql = "INSERT IGNORE INTO " . $this->pointsTable . " (id_project,id_user,webPoints, modificationDate, id_purpose) 
                        SELECT " . $id_project . ", user_id, " . $points . ", UNIX_TIMESTAMP(), 6 FROM " . $projname . "_structure WHERE (" . $cnd . ")";
                //    print "/*" . $sql . "<br>*/";
            $this->db->SQLexecute($sql);
            
        }
        
        $rtnData['success'] = TRUE;
        $rtnData['STATMENT'] = $sql;
        return json_encode($rtnData); 
    }
    
    public function addPointsToUser($userIds, $purpose, $numberOfPoints, $project_id = null)
    {
        
      //  $tmpSql[] = " id_user = " . intval($userId);
        $tmpSql[] = " id_project = 0 ";
        $tmpSql[] = " webPoints = " . intval($numberOfPoints);
        $tmpSql[] = ' modificationDate = UNIX_TIMESTAMP()';
        $id_purpose;
        
        //if $purpose is numeric means we got id. So we can insert it directly
        if(is_numeric($purpose))
            $id_purpose = intval($purpose);                
        else 
        {
            //if we get string we first have to check if this purpose already exist. If exist we just get id of it otherwise we insert new purpose
	        $id_purpose = $this->db->get($this->purposeTable, "label = '" . trim($purpose) . "'", id, DB_WARPIT_WEBCATI_BASE);   
            if($id_purpose)
                $id_purpose = intval($id_purpose[0]);
            else 
            {
                $sql = "INSERT INTO " . $this->purposeTable . " SET label = '" . mysql_real_escape_string(trim($purpose)) . "', negative = 1";  
                if(!$res = $this->db->SQLexecute($sql))
                    die($this->db->JsonError());
                
                $id_purpose = intval($this->db->GetLastInsertId());
            }
        }
        $tmpSql[] = " id_purpose = " . intval($id_purpose);
        
        if(!is_null($project_id)) $tmpSql[] = " id_project = " . $project_id;
        
        foreach($userIds as $userId)
        {
            $sql = "INSERT INTO " . $this->pointsTable . " SET " . implode(',', $tmpSql). ", id_user = " . $userId;
        
            if(!$res = $this->db->SQLexecute($sql))
                die($this->db->JsonError());    
        }
        
        
        $rtnData['success'] = TRUE;
        $rtnData['STATMENT'] = $sql;
        return json_encode($rtnData); 
        
    }

    public function getPurposesList()
    {
        $sql = "SELECT * FROM " . $this->purposeTable . " WHERE deleted = 0 AND hidden = 0";
        
        //var_dump($this->returnResults($sql, null, true));
        return $this->returnResults($sql, null, true);
    }
    
    public function removePurpose($ids)
    {
        $sql = "UPDATE " . $this->purposeTable . " SET deleted = 1 WHERE id IN(" . $ids . ")";
        if(!$res = $this->db->SQLexecute($sql))
            return $this->db->JsonError();
        
        $rtnData['success'] = TRUE;
        $rtnData['STATMENT'] = $sql;
        return json_encode($rtnData); 
    }
    
    public function removePoints($ids)
    {
        $sql = "UPDATE " . $this->pointsTable . " SET deleted = 1 WHERE id IN(" . $ids . ")";
        if(!$res = $this->db->SQLexecute($sql))
            die($this->db->JsonError());
        
        $rtnData['success'] = TRUE;
        $rtnData['STATMENT'] = $sql;
        return json_encode($rtnData); 
    }

    public function getAvaibleCoupons($id_user, $id_project)
    {
        $points = $this->getPointsByUserId($id_user);
        return $this->selectCoupons(" WHERE id_user = 0 AND incentive_points <= " . $points . " AND id_incentive_group = " . intval($id_project) . " GROUP BY incentive_points", TRUE);        
    }
    
    public function useCoupon($id_user, $coupon)
    {
        $delPart = "";
        if(intval($coupon['delete_after_download']) == 1)
            $delPart = " ,incentive_code = ''";
        
        $sql = "UPDATE " . DB_WARPIT_USERSPOOL . "._IncentiveCoupons SET id_user = " . $id_user . ", endTime = NOW() " . $delPart . " WHERE id = " . $coupon['coupon_id'];
        if(!$res = $this->db->SQLexecute($sql))
            die($this->db->JsonError());
        
    }
    
    public function getCouponsForPoints($id_project, $points)
    {
        return $this->selectCoupons("*, a.id as coupon_id","  LEFT JOIN " . DB_WARPIT_USERSPOOL . "._IncentiveProperties as b ON a.id_incentive_group = b.id 
                                             WHERE a.id_user = 0 AND a.incentive_points = " . $points . " 
                                             AND a.id_incentive_group = " . intval($id_project) . " 
                                             ORDER BY a.id ASC LIMIT 1", FALSE);
    }
    
    private function parseLabel($label, $ponts)
    {
        $exploded = explode('|', $label,2);
        return $exploded[0] . " " . $ponts . " " . $exploded[1];
    }
    
    public function getCouponForUser($id_user, $id_project)
    {
       // $id_user = 6;
        $points = $this->getPointsByUserId($id_user);
        $label = $this->db->get('_IncentiveProperties',$id_project,'project_label',DB_WARPIT_USERSPOOL);
       // var_dump($id_project);
        $coupons = $this->selectCoupons("*"," LEFT JOIN " . DB_WARPIT_USERSPOOL . "._IncentiveProperties as b ON a.id_incentive_group = b.id 
                                                WHERE a.id_user = 0 AND a.incentive_points <= " . $points . " 
                                                AND a.id_incentive_group = " . intval($id_project) . "
                                                AND NOW() BETWEEN b.start_date AND b.end_date 
                                                AND allow_download = 1
                                                GROUP BY a.incentive_points", 
                                                FALSE);
      
        $result = array();
        
        foreach($coupons['rows'] as $coupon)
            $result[] = array($coupon['incentive_points'], $this->parseLabel($label, $coupon['incentive_points']));
        
        return $result;
    }
}
?>