<?php

/*
CLASS is helper for checking timeout. it checks
*/

class SessionTimeoutHelper {

	private $db; // class to database connection
	private $UserAgent; // user agent user is using
	private $php_session_id; // 32 character ascii string created by php
	private $native_session_id; // autoincrement id in database
	private $sessionTimeOut = 6000; // 10 minutes session timeout

    private $sessionExpired = FALSE;

	/**
	 * Main constructor where  save handler and database connection is set
	 *
	 * @param object $db
	 */
	public function __construct($db) {
		$this->db = $db;
        session_set_save_handler(
			array(&$this, '_session_open_method'),
			array(&$this, '_session_close_method'),
			array(&$this, '_session_read_method'),
			array(&$this, '_session_write_method'),
			array(&$this, '_session_destroy_method'),
			array(&$this, '_session_gc_method')
		);
		$this->UserAgent = $GLOBALS["HTTP_USER_AGENT"];

		session_name("warpitSess");
		session_start();
	}

	function _session_read_method($id) {
		$this->php_session_id = $id;

		$result = $this->db->SQLexecute("SELECT a.id, logged_in ,id_user,user_type, variable_value, TIME_TO_SEC( TIMEDIFF( NOW( ) , `last_impression` ) )  as diff
											FROM  ".DB_WARPIT_MAIN."._user_session AS a
											LEFT JOIN ".DB_WARPIT_MAIN."._session_variable AS b ON a.id = b.id_session
											WHERE id_ascii_session = '".$this->php_session_id."'");

		if ($this->db->NumRows($result)) {
			$data = $this->db->fetchAssoc($result);
			$userSessionTimeOut = $this->db->get("_user", $data["id_user"], 'sessionTimeout', DB_WARPIT_MAIN);
			if($userSessionTimeOut != null)
			{
				$this->sessionTimeOut = intval($userSessionTimeOut);
			}

			if ( $data['diff'] > $this->sessionTimeOut )
			{
				$this->sessionExpired = TRUE;
            }
            else
            {
                $this->sessionExpired = FALSE;
            }
            return "";
        }
	}

    function isSessionExpired()
    {
        return $this->sessionExpired;
    }


    function _session_open_method($save_path,$session_name) {
        return (true);
    }

    function _session_close_method() {
        return (true);
    }

	function _session_write_method($id, $sess_data) {
		return (true);
	}

	function _session_destroy_method($id) {
		return (true);
	}

	function _session_gc_method() {
		return (true);
	}

}

?>
