#!/usr/bin/php
<?php

header("Content-type: text/html; charset=utf-8");
header("Cache-Control: no-cache, must-revalidate"); 
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 

ini_set('display_errors', '1');     # don't show any errors...
error_reporting(E_ALL);  # ...but do log them


// define constants
define("MAIN_TEL_TABLE", "tel___medical");
define("OUTBOUND_TEL_TABLE", "tel___DOHOD_stranke");
define("OUTBOUND_PROJECT", "DOHODNI_klici_stranke");
define("OUTBOUND_PROJECT_ID", 10);
define("PATH_TO_ROOT","/var/www/warpit/");

file_put_contents("/tmp/inbound.txt", "bobek call\r\n", FILE_APPEND | LOCK_EX);


// read all asterisk info about incoming call
$agivars = array();
while (!feof(STDIN)) {
    $agivar = trim(fgets(STDIN));
    if ($agivar === '') {
        break;
    }
    $agivar = explode(':', $agivar);
    $agivars[$agivar[0]] = trim($agivar[1]);
}
$timeInbound = time();

// Initialize database connection
include_once(PATH_TO_ROOT.'_config/dbConfig.php');
include_once(PATH_TO_ROOT.'webcati/_class/class.Inbound.php');

$inbound = new Inbound($db);

$inbound->fileLog("agivars: ".print_r($agivars,1),true,"INBOUND agivars");
$inbound->fileLog("time inbound: ".$timeInbound."\r\nagi_callerid: ".$agivars['agi_callerid']."\r\nagi_uniqueid: ".$agivars['agi_uniqueid']."\r\n\r\n",true,"INBOUND PARSE");

$inbound->prepareNumber($agivars['agi_callerid']);

// check main telephone table to get data for this number
$telData = $inbound->getFromMainTelephone();

// check call out from this number NO TIME TO PROGRAM IT TODAY...
// first change warpit to log all calls into single table


//if ($telData != false) {
	//$callOutData = $inbound->checkOutCalls($telData);
//}



// check if inbound exist and we have only tel number
if ($idDohod = $inbound->checkInbound()) {
	// update only index table
	$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE.".".OUTBOUND_PROJECT."___telIndex SET status=91, app_time=UNIX_TIMESTAMP() WHERE id_tel=$idDohod";
	$inbound->fileLog($sql,true,"update index table, telephone already exists");
	$rs = $db->SQLexecute($sql);
} else {
	// if yes or no call data, write new number for outbound call project
	if ($telData == false) {
	// insert to tel table and insert to index table
		$sql = "INSERT IGNORE INTO ".DB_WARPIT_WEBCATI_BASE.".".OUTBOUND_TEL_TABLE." SET 
					oms='".$inbound->oms."', telephone='".$inbound->telephone."',
					proj_reserved=".OUTBOUND_PROJECT_ID.", id_import=1";
		$inbound>fileLog($sql,true,"insert tel table, telephone data not exists");
	} else {
		$sql = "INSERT IGNORE INTO ".DB_WARPIT_WEBCATI_BASE.".".OUTBOUND_TEL_TABLE." SET 
					oms='".$telData['oms']."', telephone='".$telData['telephone']."', 
					region='".$telData['region']."', town='".$telData['town']."', 
					zip='".$telData['zip']."', name='".$telData['name']."', 
					address='".$telData['address']."',
					proj_reserved=".OUTBOUND_PROJECT_ID.", id_import=1";
		$inbound->fileLog($sql,true,"insert tel table, telephone data exists");
	}	
	$rs = $db->SQLexecute($sql);	
	
	// get last insert ID
	$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
	$idInserted = $db->GetLastInsertId();
	$inbound->fileLog($idInserted,true,"inserted ID");
	
	// write to index table new data for calling
	$sql = "INSERT IGNORE INTO ".DB_WARPIT_WEBCATI_BASE.".".OUTBOUND_PROJECT."___telIndex SET id_tel=$idInserted, oms=".$inbound->oms.", region=999, zip=9999";
	$inbound->fileLog($sql,true,"insert index table with new data");
	$rs = $db->SQLexecute($sql);
	
	// increment available data inside project table
	$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._Projects SET tel_reserve=tel_reserve+1 WHERE proj_name LIKE '".OUTBOUND_PROJECT."'";
	$inbound->fileLog($sql,true,"update projects table tel_reserve+1");
	$rs = $db->SQLexecute($sql);
	
}


?>