<?php
$emails   = configLoader::loadConfig('emails');
$loginOpt = configLoader::loadConfig('login');
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Warpit | Login</title>
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <link rel="stylesheet" type="text/css" href="<?php echo PATH_TO_ROOT;?>extjs/resources/css/login/reset.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo PATH_TO_ROOT;?>extjs/resources/css/login/style.css" />
    <link rel="icon" type="image/png" href="<?php echo PATH_TO_ROOT;?>_img_1/favicon.png">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>

    <style>
        body {background:#223946;}
        .login-wr {left:10%;}
        .footer {float:left; position: absolute;}
    </style>
    <![endif]-->

</head>
<body>
<!-- FAILED LOGIN POP -->
<div class="login-failed">
	<div class="act"><i class="close"></i></div>
	<div class="msg">
		<a href="mailto:<?php echo $emails['admin_email'];?>"><img src="<?php echo PATH_TO_ROOT;?>_img/loginerror.png" border=0></a>
		<h1>Login Failed</h1>
		<h4>Please try again!</h4>
	</div>
</div>
<div class="overlay"></div>

<section class="login-wr set">
    <div class="l">
        <img src="<?php echo PATH_TO_ROOT;?>extjs/resources/css/login/images/logo-2.png" alt="" class="logo">
    </div>
    <div class="r">
        <div class="login">
            <div class="row-1">
                <p><br> <strong>www.warpit.net</strong></p>
            </div>
            <div class="row-2">
                <form action="" autocomplete="off">
                    <ul>
                        <li><label for="usernamae">Username</label><input type="text" name="user" id="username" class="x-form-text x-form-field" autocomplete="off"></li>
                        <li><label for="password">Password</label><input type="password" name="pass" id="password" class="x-form-text x-form-field"></li>
                        <?php
								if($loginOpt['show_extension'] == 1 AND intval($interna))
								{
						?>
                                    <li><label for="interna">Extension number:</label><input type="number" name="interna" id="interna" class="x-form-text x-form-field"></li>
						<?php
								}
                        ?>
                        <li><label>&nbsp;</label><!--<a href="#">Forgot your password?</a>-->
                        <button type="button" id="loginBtn" class="btn x-btn-text" tabindex="-1">Log-in</button>
                    </ul>
                </form>
            </div>
        </div>
    </div>
</section>
<footer class="footer fw">
    <ul class="set">
        <li>© <?php echo date('Y'); ?> Episcenter d.o.o.</li>
        <!--<li><a href="#">Terms of Use</a></li>
        <li><a href="#">Support</a></li>-->
    </ul>
</footer>

<script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>_support/jquery.js"></script>
<script>

var usernameFocus = 1;
var showError = 0;
var overlay_and_win = $('.overlay, .login-failed');

$('#loginBtn').click(checkLogin);

var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : sParameterName[1];
        }
    }
};

function checkLogin() 
{
	$.ajax({
        url: "<?php echo PATH_TO_ROOT;?>_ajaxManipulators/ajax.Login.php",
        type: "POST",
        data: {
            action  :   'login',
            user    :   $('#username').val(),
            pass    :   $('#password').val()
<?php 
          if($interna) {
            echo ",interna  : $('#interna').val()
                  ,survey   : true";
          } else if ( $capi ) {
            echo "survey    : true";
          }
?>
        },
        success: function(data) {

            var anonymizationId = getUrlParameter('anonymizationProject');
            if ( data == 'true' ) {
                var url = "index.php";
                if( anonymizationId ) {
                    url += "?anonymizationProject=" + anonymizationId;
                }
                document.location = url;
            } else {
                overlay_and_win.fadeIn(200);
            }
        }
    });
}

$(document).keydown(function(e){
	if (e.which == '13' && usernameFocus == 1 ) {
		// on Enter keydown and focus on username change focus to password field
		$('#password').focus().select();
		usernameFocus = 0
	} else if (e.which == '13' && showError == 0 ) {
		// on Enter keydown take off focus from password and username fields
		$('#password').blur();
		$('#username').blur();
		checkLogin();
	} else if (e.which == '27' || ( e.which == '13' && showError == 1)) {
		// on ESC keydown close failed login window
		overlay_and_win.fadeOut();
		showError = 0;
		$('#username').focus().select();
	}
})

$('.overlay, .close').click(function () {
	overlay_and_win.fadeOut();
});
//on startup focus on username
$('#username').focus();
// if focus on username temp variable usernameFocus set to 1. If you click enter automaticaly focus password field
$('#username').focusin(function(){ usernameFocus = 1;})
$('#password').focusin(function(){ usernameFocus = 0;})
</script>
</body>
</html>
