<?php
namespace Steps;

use \ActionData;
use Traits\GenerateFilename;

class ExtractZip extends AbstractStep
{
  use GenerateFilename;

  public function execute($data = null)
  {

    $version = $this->versions->current('version');
    $fileName = $this->getFileName();

    $localPath =  config('localContainer'). $fileName;

    $extractTo = config('localContainer').$version. '/';
    $this->clientStatus->startExtract();
    $zip = new \ZipArchive();

    $res = $zip->open($localPath);

    $data['localPath'] = $localPath;
    $data['extractTo'] = $extractTo;

    if($res === TRUE)
    {
      $zip->extractTo($extractTo);
      $zip->close();

      $xmlFile = $extractTo;
      $xmlFile .= config('actionFileName');

      if(file_exists($xmlFile))
      {

        $this->clientStatus->zipFileExtractionSuccess($data);
      }
      else
      {
         $data['fileExists'] = false;
         $this->clientStatus->zipFileExtractionFaild($data);
      }
    }
    else
    {
        $data['localPath'] = $localPath;
        $data['extractTo'] = $extractTo;
        $this->clientStatus->zipFileExtractionFaild($data);
    }

  }
}
