<?php

namespace DataContainers;

class StatusList extends \BaseSubject
{
    private $statusList = array();

    private $restartCount = 0;

    private $updateFaild = false;

    public function addEntry($type, $data = null)
    {
      if(is_array($type))
      {
         $this->statusList[] = $type;
      }
      else
      {
        $this->statusList[] = array(
          'entryType' => $type,
          'data' => $data
        );
      }

      $this->notify();
    }

    public function getLatestStatus()
    {
         return array_pop((array_slice($this->statusList, -1)));
    }

    public function restartStatus()
    {
        $this->restartStatus++;
        $this->addEntry('restartStatusList', ['restartCount' => $this->restartStatus]);

        unset($this->statusList);
        $this->statusList = [];

    }

    public function toString()
    {
        return print_r($this->statusList, TRUE);
    }

    public function getLog()
    {
        return $this->statusList;
    }

    public function isFaild()
    {
         return $this->updateFaild;
    }

    public function setFaild()
    {
         $this->updateFaild = true;
    }



}
