<?php
include '_dirinfo.php';
require_once(PATH_TO_ROOT . '_class/createQuestion/Question.php');
include PATH_TO_ROOT . "_support/defuse-crypto.phar";

use \Defuse\Crypto\Crypto;
use \Defuse\Crypto\Key;

class Open extends Question
{
    public function __construct(db $db = null, $data = null)
    {
        parent::__construct($db, $data);
        $this->template_file = "SRtemplate.xml";
    }

    public function addQuestion(array $data)
    {

        parent::addQuestion($data);

    }

    public function updateStructure()
    {
        /*	include 'config.php';
              $this->db->ChangeDatabase($CATI_base);

              $sql = "ALTER TABLE ".$this->project."_structure ADD $this->q_name int(3)";
              $this->db->SQLexecute($sql);
            if($this->db->IsError())
                      {
                          echo $this->db->GetError();
                          return "Error";
                      }*/
    }

    public function getStructureFields($row = null)
    {
        $q = $this->q_name;
        $str = array();
        if ($this->odg_sql) {
            $ans = $this->answerToArray($this->odg_sql);
            //WARNING! I don't know if I use empty string detection anywhere!
            $leg = $this->getLegendArray();

            $str = array();
            if (count($leg) > 0) {
                for ($i = 1; $i <= count($ans); $i++) {
                    //$aId = explode(' ',$ans[$i-1],2);
                    //we save the positions on which a certain ID is!
                    $idToNum[$ans[$i - 1][0]] = $i;
                    for ($j = 1; $j <= count($leg); $j++)
                        $str[] = trim($q . '_' . $i . '_' . $j . ' ' . $this->typeBase);
                }
            } else {
                for ($i = 1; $i <= count($ans); $i++) {
                    //$aId = explode(' ',$ans[$i-1],2);
                    //we save the positions on which a certain ID is!
                    $idToNum[$ans[$i - 1][0]] = $i;
                    $str[] = trim($q . '_' . $i . ' ' . $this->typeBase);
                }

            }
        } else
            for ($i = 1; $i <= $this->open_sql; $i++) {
                $str[] = trim($q . '_' . $i . ' ' . $this->typeBase);
            }
        return $str;

    }

    public function getAnswersForSelect(&$data, &$idToNum)
    {
        $ans = $this->answerToArray($this->odg_sql);
        $leg = $this->getLegendArray();
        $hasLeg = count($leg) > 0;
        if (count($ans)) {
            foreach ($ans as $k => $val) {
                if ($hasLeg)
                    foreach ($leg as $kL => $legVal) {
                        $finD[] = ($k + 1) . '_' . ($kL + 1) . ' ' . $val[0] . ' ' . $val[1] . ' - ' . $legVal[0] . ' ' . $legVal[1];
                    }

                else
                    $finD[] = ($k + 1) . ' ' . $val[0] . ' ' . $val[1];
                //we save the positions on which a certain ID is!
                $idToNum[$val[0]] = $k + 1;
            }
        } else {
            for ($i = 1; $i <= $this->open_sql; $i++) {
                $finD[] = ($i) . '  open ' . $i;
            }
        }

        if ($finD)
            $data = implode('/', $finD);
        else
            return false;

        return true;
    }

    public function getRecodeVars()
    {
        //open answer must override this at the moment
        $this->recodeVars = $this->getStructureFields();
        $this->recodeAnswers = array();
        return array(&$this->recodeVars, &$this->recodeAnswers);
    }

    public function getDefaultValues()
    {
        $arr[] = ',open_sql,variableTypeBase,les_sql';
        $arr[] = ',1,0,6';
        return $arr;
    }

    public function changeDefaultDataType()
    {
        $this->variableTypeBase = 0;
        return $this->variableTypeBase;
    }

    public function supportedShowTypes()
    {
        return array(3, 6, 9);
    }


    public function getQType()
    {
        return "Open";
    }

    /*	commentet out since you can create open questions with ansers and/or legend!
       public function createAnswerGrid()
        {
         echo	"alert('Open questions can\'t have answers!');";
        }*/
    public function getIconCls()
    {
        return 'icon-question_op';
    }

    public function exportToExcel($rowQuestion, $tmpName = 'warpitStatistic', &$objPHPExcel, $data = null, &$i = 2)
    {
        $struct = array();
        $arr = array();
        $fields = $this->getStructureFields($rowQuestion);

        foreach ($fields as $ansField) {
            $sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $ansField IS NOT NULL $this->filter GROUP BY $ansField";

            If (!$resStat = $this->db->SQLexecute($sql)) {
                //Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
                echo "alert(\"SQL problem: " . $this->db->getError() . "\" );";
                exit;
            }

            while ($rowStat = $this->db->fetchArray($resStat)) {
                $val = trim($rowStat[0]);
                if ($val)
                    $struct[$val] += $rowStat[1];

            }
            $totalOr[] = $ansField . ' IS NOT NULL';
        }
        $sqlTotalN = "SELECT count(*) AS total_N FROM $tmpName WHERE ( " . implode(' OR ', $totalOr) . " ) $this->filter";
        If (!$resTotalN = $this->db->SQLexecute($sqlTotalN)) {
            //Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
            echo "alert(\"SQL problem: " . $this->db->getError() . "\" );";
            exit;
        }
        $totalN_arr = $this->db->fetchArray($resTotalN);
        $totalN = $totalN_arr[0];
        $realTotalN = $totalN_arr[0]; // borut add 16.10.2014, because if N=0, it shows N=1 on open question

        if ($totalN == 0) {//to avoid division by zero
            $realTotalN = 0;
            $totalN = 1;
        }
        foreach ($struct as $ans => $freq) {
            $arr[] = array($ans, $freq, $freq / $totalN * 100, strip_tags(substr($ans, 0, 50)));
        }

        parent::exportToExcel($rowQuestion, $tmpName, $objPHPExcel, array($arr, "N = $realTotalN", $rowQuestion['vpr_sql']));
        //  return $this->createStatisticsGridChart();
    }

    //20170315 Bojan Orter - I changed statistic output for open question. We add grouping by answer
    public function createStatistics($rowQuestion, $tmpName = 'warpitStatistic')
    {
        $struct = array();
        $arr = array();
        $output = [];
        $fields = $this->getStructureFields($rowQuestion);
        $answers = $this->getAnswerArray();
        $counter = 0;

        if (empty($rowQuestion["vpr_sql"])) {
            $rowQuestion["vpr_sql"] = "&nbsp;";
        }
        if($this->HTMLstat)
            echo "<table width=660 border=0 cellspacing=0 cellpadding=0><tr>";
        if($this->HTMLstat) {

            echo '<td colspan="5" align="center" style="background-color : #004AA0; color : #ffffff; padding-left : 5px; height : 30px;
	    			border-left-width : 1px;
		    		border-right-width : 1px;
			    	border-top-width : 1px;
				    border-bottom-width : 1px;
                    border-left-color : #989898;
	    			border-right-color : #989898;
		    		border-top-color : #989898;
			    	border-bottom-color : #989898;
				    border-left-style : solid;
    				border-right-style : solid;
    				border-top-style : solid;
	    			border-bottom-style : solid;
		    		FONT-FAMILY: Vardana, Arial, Helvetica, sans-serif;
			    	FONT-SIZE: 12px;
				    ">' . $rowQuestion["vpr_sql"] . '</td></tr>';
        }
        foreach ($fields as $ansField) {
            $sql = "SELECT $ansField AS variable,  count(*) AS freq FROM $tmpName WHERE $ansField IS NOT NULL $this->filter GROUP BY $ansField";

            If (!$resStat = $this->db->SQLexecute($sql)) {
                //Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
                echo "alert(\"SQL problem: " . $this->db->getError() . "\" );";
                exit;
            }

            while ($rowStat = $this->db->fetchArray($resStat)) {
                $val = trim($rowStat[0]);
                if ($val)
                $struct[$val] += $rowStat[1];

            }
            $sqlTotalN = "SELECT count(*) AS total_N FROM $tmpName WHERE (CHAR_LENGTH($ansField) > 0 AND $ansField IS NOT NULL) $this->filter";

            If (!$resTotalN = $this->db->SQLexecute($sqlTotalN)) {
                echo "alert(\"SQL problem: " . $this->db->getError() . "\" );";
                exit;
            }
            $totalN_arr = $this->db->fetchArray($resTotalN);
            $totalN = $totalN_arr[0];
            $realTotalN = $totalN_arr[0]; // borut add 16.10.2014, because if N=0, it shows N=1 on open question

            if ($totalN == 0) {//to avoid division by zero
                $realTotalN = 0;
                $totalN = 1;
            }
            foreach ($struct as $ans => $freq) {
                $arr[] = array($ans, $freq, $freq / $totalN * 100, strip_tags(substr($ans, 0, 50)));
            }

            $answer = (count($answers) > 0) ? $answers[$counter][1] : "";
            $counter++;

            $this->createStatisticsGridChart($arr, null, "$answer N = $realTotalN");

            $output[] = $struct;
            $arr = Array();
            $struct = Array();

        }
        if($this->HTMLstat)
            echo "</table><br><br><br><br>";

        return $output;
    }

    //END

    public function designerRequiresTemplate()
    {
        return $this->odg_sql ? true : false;
    }

    public function designerDrawAnswers()
    {
        $surveyConfig = configLoader::loadConfig('survey');

        $fields = $this->getStructureFields();

        $_SESSION['questionFields'] = array_merge($_SESSION['questionFields'], $fields);
        $counter = 0;
        //let's check if there is some special blabla for this control
        global $projectId;
        $controlTemplate = simplexml_load_string($this->display->readXML($this->id, $projectId, 7));
        if ($controlTemplate) {
            $controlStyle = $controlTemplate->DIV->attributes();
            if ($controlStyle['RMclass'])
                $controlStyle = $this->display->getCssStyles($controlStyle['RMclass']);
            else
                $controlStyle = '';
        }
        if ($this->display->engine->LeaveQuestion === false)
            $fieldsValues = $_POST['answers'];
        else
            $fieldsValues = $this->display->readStructureVariables($fields, '');


        if ($this->odg_sql)//if open have answers we create a textarea for each answer
        {
            $this->db->LogWrite($this->odg_sql, false, "show open answers");

            $ansArr = $this->answerToArray($this->odg_sql);

            $ansArr = $this->designerRotateAnswers($ansArr);
            $this->designerFilterAnswers($ansArr);
            $legArr = $this->answerToArray($this->display->readRequiredQuestionVariables($this->leg_sql));
            $hasLegend = count($legArr) > 0;
            if ($hasLegend) {
                $legArr = $this->designerRotateAnswers($legArr, true);
                $this->designerFilterAnswers($legArr, true);
                $divide = count($legArr);
                $legSize = count($legArr);

            } else
                $divide = 1;


            $this->designerDefineObjects($divide);

            $tbl = "<table class='answersTable' $this->mainStyle cellpadding=0 cellspacing=0 width=100%>";

            $tbl .= $this->getSingles();

            if ($hasLegend) {
                $tbl .= "<tr>";
                foreach ($this->legRow->children() as $child) {

                    $attr = $child->attributes();
                    switch ($attr['type']) {
                        case 20:
                            if ($this->showVal) {
                                $size = $useStyle[20];
                                $tbl .= "<td $size>$value</td>";
                            }
                            break;
                        case 21:
                            $size = $useStyle[21];
                            $tbl .= "<td $size>$label</td>";

                            break;
                        case 22:
                            foreach ($legArr as $index => $ans) {
                                $hmm = $ans[1];
                                $size = $this->legStyle[22];
                                $tbl .= "<td $size>$hmm</td>";
                            }

                            break;
                    }


                }
                $tbl .= "</tr>";
            }

            $ansCount = 1;
            foreach ($ansArr as $index => $ans) {
                $value = $ans[0];
                /**
                 * Borut changed on 23.4.2013, image load was broken because readRequiredQuestionVariables was called on whole string
                 * 20 lines up
                 */
                //$label = $ans[1];
                $label = $this->display->readRequiredQuestionVariables($ans[1]);
                //28.1.2015 Tanis, if your answer contains pipe simbol we split it at pipe end put text on the end of input
                if (strpos($label, '|') !== false) {
                    $explodePipe = explode('|', $label);
                    $label = trim($explodePipe[0]);
                    $subLabel = trim($explodePipe[1]);
                }

                $tbl .= "<tr>";
                if ($ansCount % 2 == 1) // odd rows
                {
                    $useRow = $this->oddRows;
                    $useStyle = $this->oddStyle;
                } else {
                    $useRow = $this->evenRows;
                    $useStyle = $this->evenStyle;
                }
                foreach ($useRow->children() as $child) {
                    $attr = $child->attributes();
                    switch ($attr['type']) {
                        case 20:
                            if ($this->showVal) {
                                $size = $useStyle[20];
                                $tbl .= "<td " . $size . " >";
                                $tbl .= $value;
                                $tbl .= "</td>";
                            }
                            break;
                        case 21:
                            $size = $useStyle[21];
                            $tbl .= "<td " . $size . ">";
                            $tbl .= $label;
                            $tbl .= '</td>';
                            break;
                        case 22:
                            $size = $useStyle[22];
                            $ansCndLeg = array();
                            if ($hasLegend) {
                                //we go trough each legend and draw it
                                foreach ($legArr as $legIndex => $leg) {

                                    $legVal = $leg[0];

                                    $inputKey = trim($this->q_name . "_" . ($index + 1) . "_" . ($legIndex + 1));

                                    $valueForDisplay = $fieldsValues[$inputKey];

                                    if (strlen($valueForDisplay) && $this->encrypt == 1) {
                                        $valueForDisplay = Crypto::decrypt($valueForDisplay, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));

                                    }

                                    //the type of display depends on les_sql
                                    $tbl .= "<td " . $size . ">";
                                    $tbl .= $this->getInputFieldHtml($inputKey, $valueForDisplay, $controlStyle, $this->getInputType($index));

                                    $tbl .= "</td>";
                                    // MUST ANSWER condition generate
                                    $ansCndLeg[] = "strlen( $" . $inputKey . " ) > 0";

                                }
                                /*echo "<pre>";
                                    var_dump($ansCndLeg);
                                echo "<pre>";*/

                            } else {
                                $valueForDisplay = $fieldsValues[trim($fields[$index])];
                                if (strlen($valueForDisplay) && $this->encrypt == 1) {
                                    $valueForDisplay = Crypto::decrypt($valueForDisplay, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));

                                }


                                //    var_dump([$this->getInputProperties($index), $index]);

                                $tbl .= "<td " . $size . ">";
                                $tbl .= $this->getInputFieldHtml(
                                    $fields[$index],
                                    $valueForDisplay,
                                    $controlStyle,
                                    $this->getInputType($index),
                                    $this->getInputProperties($index)
                                );


                                if (!$GLOBALS['focuseSet']) {
                                    $tbl .= "<SCRIPT>   document.forms['mainForm']['answers[" . $fields[$index] . "]'].focus()  </SCRIPT>";
                                    $GLOBALS['focuseSet'] = true;
                                }
                                if (isset($subLabel)) {
                                    $tbl .= " " . $subLabel;
                                    unset($subLabel);
                                }
                                $tbl .= "</td>";


                                $ansCndLeg[] = "strlen( $" . trim($fields[$index]) . ")>0";
                            }

                            break;
                    }
                }
                $tbl .= "</tr>";
                $ansCount++;

            }
            $tbl .= "</table>";
        } else {
            for ($i = 1; $i <= $this->open_sql; $i++) {

                $valueForDisplay = $fieldsValues[trim($fields[$counter])];

                if (strlen($valueForDisplay) && $this->encrypt == 1) {
                    $valueForDisplay = Crypto::decrypt($valueForDisplay, Key::loadFromAsciiSafeString($surveyConfig['encryptionKey']));

                }

                $tbl .= $this->getInputFieldHtml($fields[$counter], $valueForDisplay, $controlStyle);

                if (!$GLOBALS['focuseSet']) {
                    $tbl .= "<SCRIPT>   document.forms['mainForm']['answers[" . $fields[$counter] . "]'].focus()  </SCRIPT>";
                    $GLOBALS['focuseSet'] = true;
                }
                $counter++;

            }
            $ansCndLeg[] = '( strlen($' . $fields[0] . ') > 0 )';
        }
        //echo "<pre>";
        //var_dump($ansCndLeg);
        //echo "</pre>";
        if ($this->must_answer) {
            $_SESSION['leaveConditions'][$this->q_name] = implode(' AND ', $ansCndLeg);
            $this->setMustAnswerCondition(implode(' AND ', $ansCndLeg));
        }

        $tbl .= $this->getInputPosition();
        return $tbl;
    }

    protected function getSinglesFile()
    {
        return "<script src='javascript/openAsSingle.js'></script>";
    }

    protected function getInputFieldHtml($id, $valueForDisplay, $controlStyle, $definedInputType = null, $definedInputProperties = '')
    {
        $inputTag = "textarea";
        $inputType = "";

        if (in_array($this->les_sql, [3, 9])) {
            $inputTag = "input";
            $inputType = "text";

            if ($this->les_sql == 9) {
                $inputType = "numeric";
            }

            if ($this->variableTypeBase == 4) {
                $inputType = "number";
            }
        }

        if ($definedInputType !== null) {
            $inputType = $definedInputType;
        }

        $typeProperty = ($inputTag == "textarea") ? "" : " type='$inputType'";
        $valueProperty = ($inputTag == "textarea") ? ">$valueForDisplay</textarea" : " value='$valueForDisplay' ";

        $typeProperty .= ' ' . $definedInputProperties;

        return "<$inputTag $typeProperty onclick='recodeClickEvents(this,1);' onblur='recodeClickEvents(this,2);' style='$controlStyle' id='ct_$id' name=answers[$id] $valueProperty >";
    }

    protected function printAnswerTable()
    {
        echo "<div Style=\"margin-left : 20px; \">";
        if ($this->record_data) {
            $this->printGetRecValues();
            $i = 0;
            foreach ($this->dataValues as $ans) {
                if ($this->printEdit)
                    echo "<textarea cols=100 rows=5 name=editVal[{$this->fld[$i]}] >$ans</textarea><br>";
                else
                    echo "<span style='background:red'>$ans</span><br>";
                $i++;
            }

        } else {
            echo "<font size=1px><br></font>";
            echo "__________________________________________________________________<br>";
            echo "<font size=1px><br></font>";
            echo "__________________________________________________________________";
        }
        echo "</div>";
    }

    public function getSelectedValue($fieldsValues, $key = null)
    {
        //TODO tis won't work if we have more then 1 open end question
        return $fieldsValues[$this->q_name . '_' . $key];
    }

    public function getQuestionField($fields, $key = null)
    {
        return $fields[$key];
    }

    protected function buildMustAnswerCondition($answerIndex, $answerValue)
    {
        return 'strlen($' . $this->q_name . '_' . $answerIndex . ') > 0';
    }

    protected function getInputPosition()
    {
        if($this->input_position === "1"){
            return '';
        }

       return "<style>
            @media all{
                table.answersTable > tbody > tr,
                table.answersTable > tbody > tr > td {display:block; width:100%!important;}
                table.answersTable > tbody > tr + tr {margin-top:5px}
            }
        
        </style>
        ";
    }

}

?>
