<?php 

class MakeComponent
{
	function __construct($varName = null)
	{
		$this->rndID = mt_rand();
		if($varName)
		{
			$this->compName = $varName;
		}
		else 
		{
			$this->compName = 'grid'.$this->rndID;
		}
		//let's set some defaults
		$this->setClosable();
	}
	
	protected $newLine = "\n";
	public $selectSQL = false;
	
	protected $compName;
	
	public $rndID;
	
		/*
	 * If the source is a database table we need to configure this properties
	 */
	public $table;
	protected $database;
	
	/*
	 * The formats for the dates
	 */
	public $dateSQL = 'Y-m-d';
	public $dateDisplay = 'd.m.Y';
	
	protected $tBarItems = array();
	
	/**
	 * array of component items
	 *
	 * @var unknown_type
	 */
	protected $items = array();
	
	protected $addTBar = false;
	//array of all config items for the tree
	protected $configs = array();
	
	//array that is holding all of the listeners
	public $listeners = array();
	
	
	//an array to store all the plugins
	public $plugins;
	
	//all styles to be added via function setClassStyle function
	protected $styleClasses;
	
	protected $cls;
	
/**
	 * Get the name of the component, which is used as the id of the ExtJS component
	 *
	 * @return string
	 */
	function getName()
	{
		return $this->compName;
	}
	
	/**
	 * sets the table which will be send to the ajax file for retriving data
	 *
	 * @param unknown_type $table
	 * @param unknown_type $database
	 * @param unknown_type $key
	 * @return MakeGrid
	 */
	function setMainTable($table,$database = null, $key = 'id')
	{
		$this->table = $table;
		$this->mainKey = $key;
		if($database)
			$this->database = $database;
		
		return $this;
	}
	
	protected $title;
	/**
	 * The title of the component if needed
	 *
	 * @param unknown_type $url
	 * @return MakeComponent
	 */
	function setTitle($title,$iconCls = null)
	{
		$this->title = $title;
		$this->configs['title'] = "'$title'";
		if($iconCls)
			$this->configs['iconCls'] = "'$iconCls'";
		
		return $this;
	}
	
	
	/**
	 * The url of the ajaxmanipulator! 
	 * Each class has a default : _ajaxManipulators/`comp`DataManipolator.php
	 *
	 * @param unknown_type $url
	 * @return MakeComponent
	 */
	function setReqUrl($url)
	{
		$this->reqUrl = $url;
		if(!isset($this->table) )
		{
			$this->table = true;
		}
		return $this;
	}
	public function __toString()
	{
		return $this->getName();
	}
/**
	 * Sets the database which is sent to the ajax call (can also be set with setMAinTable)
	 *
	 * @param unknown_type $database
	 * @return MakeGrid
	 */
	function setDatabase($database)
	{
		$this->database = $database;
		return $this;
	}
	
	/**
	 * Adds an item to the tbar of the component! Enter in ExtJS object creation code ( {} ) or the id of the object (trough $comp.getName() )
	 *
	 * @param unknown_type $database
	 * @return MakeComponent
	 */
	public function addtBarItem($item)
	{
		$this->addTBar = true;
		$this->tBarItems[] = $item;
		return $this;
	}
	
	/**
	 * Adds an item to the bbar of the component! Enter in ExtJS object creation code ( {} ) or the id of the object (trough $comp.getName() )
	 *
	 * @param unknown_type $database
	 * @return MakeComponent
	 */
	public function addBottomBarItem($item)
	{
		$this->addBBar = true;
		$this->bBarItems[] = $item;
		return $this;
	}
	
	
	protected $editable = false;
	/**
	 * Sets if items of components are editable (currently used for tree items and grid items)
	 * Warning: in grid it only activates the after edit...each column needs an editor in order to be editable!
	 *
	 * @param unknown_type $text
	 * @return MakeComponent
	 */
	public function setEditable($bool = true)
	{
		$this->editable = $bool;
		return $this;
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeComponent
	 */
	public function setHeight($value)
	{
		$this->configs['height'] = $value;
		return $this;
	}
/**
	 * Enter description here...
	 *
	 * @param unknown_type $text
	 * @return MakeComponent
	 */
	public function setWidth($value)
	{
		$this->configs['width'] = $value;
		return $this;
	}
	/**
	 * Add custom config options!
	 * Here you can add component configs that are not accesible trough functions (e.g autoHeight,padding etc ) 
	 * WARNING: the options should have quote marks if neccesery!
	 *
	 * @param unknown_type $conf
	 * @param unknown_type $opt
	 * @return MakeComponent
	 */
	
	public function addConfig($conf,$opt)
	{
		if ($conf == 'cls')
		{
			$this->addCls($opt);
		}
		else 
			$this->configs[$conf] = $opt;
			
		return $this;
	}
/**
	 * Add listeneer
	 *
	 * @param unknown_type $event - the name of the event to listen t
	 * @param unknown_type $function - the handler
	 * @return MakeComponent
	 */
	
	public function addListener($event,$function)
	{
		

		$this->listeners[] = " $event : $function ";
			
		return $this;
	}
	/**
	 * If the component is closable in a tabItem!
	 *
	 * @param unknown_type $bool
	 * @return MakeComponent
	 */
	public function setClosable($bool = true)
	{
		if($bool && $bool !== 'false'  )
		{	
			$this->addConfig('closable','true');
		}
		else 
		{
			$this->addConfig('closable','false');
		}
	
		return $this;
	}
	/**
	 * adds custom CLS classes to the component
	 *
	 * @param unknown_type $bool
	 * @return MakeComponent
	 */
	public function addCls($opt)
	{
		
		$this->cls[] = $opt;
		return $this;
	}
	/**
	 * Sets the region of the component e.g center, west, east
	 *
	 * @param unknown_type $bool
	 * @return MakeComponent
	 */
	public function region($text)
	{
		$this->configs['region'] = "'$text'";
		return $this;
	}
	/**
	 * Sets the flex of the component for in box layout use
	 *
	 * @param unknown_type $bool
	 * @return MakeComponent
	 */
	public function flex($text)
	{
		$this->configs['flex'] = $text;
		return $this;
	}
	
	protected function createConfigs()
	{
		if (isset($this->cls))
		{
			$this->configs['cls'] = "'". implode(' ',$this->cls) ."'";
		}
		foreach ($this->configs as $conf =>$opt) 
		{
			$tmp.= ", $conf : $opt";
		}
		if (isset( $this->buttons)  )
		{
			$tmp .= ",buttons:[".implode(',',$this->buttons).   "]";
		}
		if(isset($this->listeners))
		{
			$tmp .=" ,listeners: {";
			 $tmp.=  implode(',',$this->listeners). "}";
		}
		
		return $tmp;
		
	}
	
	protected $buttons;
	protected function addButton($text,$function)
	{
		$this->buttons[] = "{ text : '$text',handler: $function  }";
	}
	
	protected function configRMconn($comp = 'comp')
	{
	 	$rmConn = "new RMajax({url:'$this->reqUrl',
	 	params:{'RMtable':'$this->table',database:'$this->database',RMcomp:'$comp'";
		if(isset($this->baseParams))
		{
			$rmConn.=','.$this->baseParams;	
		}
		$rmConn .= "} })";
		
		$this->configs['RMconn'] = $rmConn;
	}
	
	
	
	
	
}

?>