<?php



class GridDataManipulator{
	/*
	 * Load tree node.
	 */

	protected $db;
	protected $table;
	protected $where;
	protected $addOnTable;
	protected $addOnTable_where;


	function __construct($db,$table)
	{
		$this->db = $db;
		$this->table = $table;

        //7.1.2015 sql injection
       if(class_exists('convert'))
        {

            if(isset($_POST['srcquery'])) $_POST['srcquery'] = convert::toString($_POST['srcquery']);
            if(isset($_POST['defaultValues'])) $_POST['defaultValues'] = convert::toString($_POST['defaultValues']);
            if(isset($_POST['id']))
            {
                if(is_array($_POST['id']))
                {
                    $tmp = $_POST['id'];
                    foreach($tmp as $key => $val) $_POST[$key] = convert::toString($val);
                }
                else
                    $_POST['id'] = convert::toString($_POST['id']);
            }
            if(isset($_POST['RMtable'])) $_POST['RMtable'] = convert::toString($_POST['RMtable']);
            if(isset($_POST['SQL'])) $_POST['SQL'] = convert::toString($_POST['SQL']);
            if(isset($_POST['SQLwhere'])) $_POST['SQLwhere'] = convert::toString($_POST['SQLwhere']);
            if(isset($_POST['autoFill'])) $_POST['autoFill'] = convert::toString($_POST['autoFill']);
            if(isset($_POST['sort'])) $_POST['sort'] = convert::toString($_POST['sort']);
            if(isset($_POST['limit'])) $_POST['limit'] = convert::toInt($_POST['limit']);
            if(isset($_POST['start'])) $_POST['start'] = convert::toInt($_POST['start']);
            if(isset($_POST['nodeId'])) $_POST['nodeId'] = convert::toInt($_POST['nodeId']);
            if(isset($_POST['groupBy'])) $_POST['groupBy'] = convert::toString($_POST['groupBy']);
            if(isset($_POST['dir'])) $_POST['dir'] = convert::toAlfaNum($_POST['dir']);
            if(isset($_POST['par'])) $_POST['par'] = convert::toInt($_POST['par']);
            if(isset($_POST['defaultFields'])) $_POST['defaultFields'] = convert::toString($_POST['defaultFields']);
            if(isset($_POST['field'])) $_POST['field'] = convert::toString($_POST['field']);
            if(isset($_POST['ids'])) $_POST['ids'] = convert::toString($_POST['ids']);
            if(isset($_POST['RMcomp'])) $_POST['RMcomp'] = convert::toString($_POST['RMcomp']);
            if(isset($_POST['id_project'])) $_POST['id_project'] = convert:: toInt($_POST['id_project']);

        }
	}
	function makeSaveFieldName(array $fields)
	{
        $parsedFields = [];
        foreach($fields as $field){
            if(strpos($field, '.') !== false){
                list($tableAlias, $fieldName) = explode('.',$field);
                $parsedFields[] = $tableAlias . ".`{$fieldName}`";
            } else {
                $parsedFields[] = "`$field`";
            }
        }

        return $parsedFields;
	}

    function parseSort($sortString){
        $fields = explode(',', $sortString);

        $parsedFields = $this->makeSaveFieldName($fields);

        return implode(',',$parsedFields) . ' ' . $_POST['dir'];
    }

	function addWhere($condition)
	{
		$this->where[] = $condition;
	}
	/**
	 * Creates the select statement from all the parameters without limit AND order!!!
	 *
	 */
	function createSelectSQL()
	{
		$this->db->LogWrite("kliče selectsql",false,"kliče ");
		if(isset($_POST['SQL']))
		{

			$sql = stripslashes( $_POST['SQL']);
		}
		else if($_POST['autoFill']) //in case a combobox want's to automaticly get some shit...yeah...
		{
			$af = $_POST['autoFill'];
			$q = $_POST['query'];
			$sql = "SELECT `$af` FROM `$this->table` GROUP BY `$af` HAVING $af LIKE '$q%' ORDER BY `$af`";
		}
		else
		{
			$sql = "SELECT * FROM $this->table";
		}
		//custom where statement send by parameters
		$postWhere = $_POST['SQLwhere'];
		if($postWhere)
		{
			$this->where[] = $postWhere;
		}

		//filtering
		if(isset($_POST['filter']) || isset($_POST['srcfields']))
		{
			$this->where[] = $this->filtering($_POST['filter']);
			//$sql .= $this->filtering($_POST['filter']);
		}
		//remote sorting
		if(isset($_POST['sort']) || isset($_POST['groupBy']) )
		{
		//	$sql .= ' ORDER BY ';
		//	$this->sort = array();

			if( isset($_POST['groupBy']) && $_POST['groupBy']!=$_POST['sort'] )
			{
				$this->sort[] = $_POST['groupBy'].' '.$_POST['groupDir'];
			}
			if(isset($_POST['sort']) ) {
				$this->sort[] = $this->parseSort($_POST['sort']);
			}

		//	$sql .= implode(',',$sort);

		}
		if (is_array($this->where))
		{
			if(!$this->whereKeyword) $this->whereKeyword = "WHERE";
			$sql .= " $this->whereKeyword ".implode(' AND ',$this->where);
		}
		return $sql;
	}
	/**
	 * Fetches all the data and stores it in an array
	 *Its now seperated from selectAction so that you may call it independetly
	 *
	 * @return Array with data
	 */
	function fetchSelect()
	{
		$this->db->LogWrite("kliče fetch select",false,"kliče fetch select");
		//made a seperate createSelect function, to use in cases like export, copy all filtered records etc!
		$this->sql = $this->createSelectSQL();
		$this->db->LogWrite($this->sql,false,"Sledim grajenju SQLa (after createSelectSQL()):");


		//if paging is activated
		if (isset($_POST['start']) )
		{
			$countSql = $this->sql;

			if($_POST['limit'] < 0 ) $_POST['limit'] = 20;

				$limit .= ' LIMIT '.$_POST['start'].", ".$_POST['limit'];


			if(!$this->rsCount = $this->db->SQLexecute($countSql))
			{
				return false;
			}
			$this->results = $this->db->NumRows($this->rsCount);
		}


		if (is_array($this->sort) )
		{
			$this->sql .= ' ORDER BY '.implode(',',$this->sort);
		}
		$this->sql .= $limit;
		$this->db->LogWrite($this->sql,false,"Sledim grajenju SQLa (pred SQLexecute()):");
		if ($this->ExportDataFlag) {
			If (!$this->ExportDataResult = $this->db->SQLexecute($this->sql))
				return false;
			 else
				return true;

		} else {
			If (!$this->rs = $this->db->SQLexecute($this->sql))
			{
				return false;
			}
			$this->arr = array();
			while($obj = $this->db->fetchAssoc($this->rs)){
				$this->arr[] = $obj;
			}
			return $this->arr;
		}
	}
 	function  selectAction()
 	{
 		$this->db->LogWrite(json_encode($this->arr),true,"polje izpisano:");
 		$echo = '{success:true';

 		if(!isset($this->arr) )
 		{

 			if($this->fetchSelect() === false) return $this->db->JsonError();
 		}

 		if($_POST['addOn'])
 		{

 			if($_POST['addOn'] == 'setSelection')
 			{

	 			if (is_array($this->where))
				{
					if(!$this->whereKeyword) $this->whereKeyword = "WHERE";
					$updateWhere .= " $this->whereKeyword ".implode(' AND ',$this->where);
				}
				$val = $_POST['setValue'];
				if(!is_numeric($val) )
					$val = "'$val'";

				$setUpdateSql = "UPDATE $this->table $this->addOnTable SET ".$_POST['setField']." = $val ".$updateWhere." ".$this->addOnTable_where;

				unset($this->addOnTable);
				unset($this->addOnTable_where);

				//$this->db->LogWrite($setUpdateSql,false,"class.gridData -> selectAction");
				try{
					echo "/*poskusam najprej tale update: $setUpdateSql*/";
					$this->db->SQLexecute($setUpdateSql);
				}
				catch (Exception $e)
				{//ce ne uspe gremo oni stari nacin!
					foreach ($this->arr as $bla) {
 						$selIds[] = $bla['id'];
	 				}
	 				$_POST['ids'] = implode(',',$selIds);
	 				$this->setSelectionAction();
				}
				$this->fetchSelect();
 			}
 		}

 		$this->db->LogWrite($this->results,false,"pride sem");
		if (isset($_POST['start']) )
		{
			$echo.= ', results:'.$this->results;
		}

			$echo.= ', STATEMENT: "'.$this->sql.'",rows: '.json_encode($this->arr);
			$echo.='}';
			$this->db->LogWrite($echo,true,"izpis podatkov");
			return $echo;
 	}
	function deleteAction()
	{
	        if(!$idField = $_POST['idField'])
			$idField = 'id';

		if($_POST['id'])
		{

		$sql = 'DELETE FROM '.$_POST['RMtable'].' WHERE '.$idField.' = '.$_POST['id'];
		}
		elseif ( $_POST['ids'] )
		{          
			$sql = 'DELETE FROM '.$_POST['RMtable'].' WHERE '.$idField.' IN  ('.$_POST['ids'].')';
		}
		else
		{
		    return '{success:false,error:"No ID found!"}';
		}
		If ( !$this->db->SQLexecute($sql) ) {
		    return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
		} else {
           	    return '{success:true }';
		}
	}
	function updateAction()
	{
		$_POST['value'] = addslashes($_POST['value']);

		if($_POST['whereField']) //added by Sandi Jersic, 25.11.2013
			$whereField = $_POST['whereField'];
		else
			$whereField = 'id';

		//$sql = 'UPDATE '.$_POST['RMtable']." SET ".$_POST['field']." = '".$_POST['value']."' WHERE id = ".$_POST['id']; //this was original until 25.11.2013
		$sql = 'UPDATE '.$_POST['RMtable']." SET `".$_POST['field']."` = '".$_POST['value']."' WHERE ".$whereField." = ".$_POST['id'];
			If (!$rs = $this->db->SQLexecute($sql)) {

				Echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';

			}else{



			$r = '{success:true';
			if($_POST['newValue'] == true)
				$r .= ',newValue:"'.$_POST['value'].'"';
			return $r. ',error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
		}

	}
	function setSelectionAction()
	{
		$val = $_POST['setValue'];

		$cleanSetField = $this->makeSaveFieldName([$_POST['setField']]);
		$cleanSetField = array_shift($cleanSetField);

		if(!is_numeric($val) ){
            $val = "'$val'";
        }

		if($ids = $_POST['ids']){
			$sql = "UPDATE $this->table as a SET ".$cleanSetField ." = $val WHERE id IN ($ids)";
			$this->db->SQLexecute($sql);
		}

		echo "/*updating all selected rows: $sql*/";
		return "{success:true}";

	}
	function insertAction()
	{
		$sql = 'INSERT INTO '.$_POST['RMtable'];
			$val = '';
			if(isset($_POST['defaultFields']))
			{
				$sql .= '('.$_POST['defaultFields'].')';
				$val = str_replace( '\\','', $_POST['defaultValues']) ;

			}
			$sql .= " VALUES($val)";

		If (!$rs = $this->db->SQLexecute($sql)) {

					return '{"success":false,"error":"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';

				}else{



				return  '{"success":true,"insert_id":'.$this->db->GetLastInsertId().' }';
			}
	}
	function exportAction()
	{
		//var_dump($_POST);
		$expCol = json_decode(stripslashes($_POST['cols']));
		$expHead = json_decode(stripslashes($_POST['heads']));
		$this->db->SQLexecute('DROP TEMPORARY TABLE IF EXISTS exportTMP');

		//var_dump($expCol);

		if($_POST['arrayExport'])
		{
			$arr = json_decode($_POST['data']);
		}
		else
		{

			$this->db->SQLexecute('SET NAMES UTF8');

		}
			 unset($_POST['start']);
			 unset($_POST['limit']);
			 $this->ExportDataFlag = TRUE;
			$this->selectAction();
            //print " sql: " . $this->sql; exit;
			/*echo "<pre>";
			var_dump($this->arr);
		echo "</pre>";
			*/
			$arr = $this->arr;

			//20160504 Bojan Orter - changed from import_option to export_option
			//Loading config where we read default encoding
			$exportOption = configLoader::loadConfig('export_option');
			$encoding = $exportOption['cp_default'];

			//20162604 Bojan Orter - We also need to conver to right encoding so we use
			//helping class ConvertCodepage for converting between encoding
			require_once(PATH_TO_ROOT . "_class/class.ConvertCodepage.php");
			$converter = new ConvertCodepage();

			if($_POST['RMexport']=='excel')
			{
				//20162504 Bojan Orter - I changed excel export to be done with PHPExcel library,
				//first we prepare or data and then we write it to xlsx file
				require_once(PATH_TO_ROOT . "_support/PHPExcel.php");
				$objPHPExcel = new PHPExcel();

				$objPHPExcel->getProperties()->setTitle('PHPExcel Test Document');
				$objPHPExcel->setActiveSheetIndex(0);

				$iCol = 0;
				foreach ($expHead as $key=>$val)
				{
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($iCol++, 1, $val);
				}

				$data = array();
				foreach ($arr as $row) {
   					$rowDisplay = array();
   					foreach ($expCol as $colName) $rowDisplay[] = $converter->convert_string("utf-8", $encoding, $row[$colName]);   //iconv("utf-8","windows-1252",$row[$colName]);//$row[$colName]//iconv("utf8","cp1250",$row[$colName]);
   					$data[] = $rowDisplay;
   				}

				while($row = $this->db->fetchAssoc($this->ExportDataResult)){
					$rowDisplay = array();
   					foreach ($expCol as $colName) $rowDisplay[] = $converter->convert_string("utf-8", $encoding, $row[$colName]); //$converter->convert_string("utf-8", "windows-1252", $row[$colName]);//$row[$colName]; //iconv("utf8","cp1250",$row[$colName]);
   					$data[] = $rowDisplay;
   				}
				$objPHPExcel->getActiveSheet()->fromArray($data, NULL, 'A2');

				header("Content-type: application/vnd.ms-excel;charset=$encoding");
				header('Content-Disposition: attachment; filename="export.xlsx"');

				// Write file to the browser
				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
				$objWriter->save('php://output');

			}
			elseif ($_POST['RMexport']=='csv')
			{

				header( "Content-Type: text/csv; charset=$encoding");
   				header( "Content-Disposition: attachment; filename=\"export.csv\";" );

   				$fp = fopen('php://temp', 'w');
   				foreach ($expHead as $key=>$val) $expHead[$key] = str_replace("&nbsp;"," ",strip_tags($val)); // $expHead[$key] = iconv("utf8","cp1250",$val);
   				fputcsv($fp, $expHead,';');
   				//echo implode(';',$expHead)."\n";

   				while($row = $this->db->fetchAssoc($this->ExportDataResult)){
   					$rowDisplay = array();
   					foreach ($expCol as $colName) $rowDisplay[] = $converter->convert_string("utf-8", $encoding, $row[$colName]); //iconv("utf-8","cp1252",$row[$colName]);
   					fputcsv($fp, $rowDisplay,';');
   				}

   				foreach ($arr as $row)
				{
					$rowDisplay = array();
					foreach ($expCol as $ColKey) $rowDisplay[] = $converter->convert_string("utf-8", $encoding, str_replace(".",",",$row[$ColKey]));
   					fputcsv($fp, $rowDisplay,';');
   				}

   				//fputcsv($fp, $_POST,';');

   				rewind($fp);
   				echo stream_get_contents($fp);
   				fclose($fp);

			}
			elseif($_POST['RMexport']=='xml')
			{
				header("Content-Type: text/xml;charset=$encoding");
				header('Expires: 0');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
				header('Content-Disposition: attachment; filename=\"export.xml";');
   				$XMLwr = new XMLWriter();
   				$XMLwr->openMemory();
   				$XMLwr->startDocument('1.0', $encoding);
   				$XMLwr->startElement('data');


				while($row = $this->db->fetchAssoc($this->ExportDataResult)){
					$XMLwr->startElement('row');

					//20162504 Bojan Orter - We only need data we see in form and not all the data that table has
					//for example: In show group we can select witch columns are viseble, so we export only those, not all columns that exist
					foreach ($expCol as $colName)
					{
						$XMLwr->writeElement($colName, $row[$colName]);
					}
   					/*foreach ($row as $di => $value) {
   						$XMLwr->writeElement($di,$value);
   					}*/
   					$XMLwr->endElement();
   				}

				foreach ($arr as $row)
				{
					$XMLwr->startElement('row');

					//20162504 Bojan Orter - We only need data we see in form and not all the data that table has
					//for example: In show group we can select witch columns are viseble, so we export only those, not all columns that exist
					foreach ($expCol as $colName)
					{
						$XMLwr->writeElement($colName, $row[$colName]);
					}
					/*foreach ($row as $di => $value) {
   						$XMLwr->writeElement($di,$value);
   					}*/
   					$XMLwr->endElement();

   				}
   				$XMLwr->endElement();
   				$XMLwr->endDocument();
   				echo $XMLwr->flush();
			}



	}

	public function pasteImportAction()
	{

		$data = explode("\n",$_POST['pasteData']);
		$cols = $_POST['cols'];
		$l = count($data);
		$firstRow = explode("\t",$data[0]);
		//let's check for special RM code ;)
		$code = $firstRow[4];
		if(substr($code,0,9) == '00RMIjC00')
		{
			$rowData = (int)substr($code,9,2) - 1;
			$rowHeaders = (int)substr($code,11,2);
			$idCol = (int)substr($code,13,2);
			//echo "code found!!! :)";
			if($rowHeaders)
				$cols = $data[$rowHeaders - 1];
			else  //we add the id that we added in exprot (maybe some code will be requered for this ? )
				$cols = 'id,'.$cols;

		}
		else //there is no code
		{
			//we asume that only data is pastet!
			$rowData = 0;
		}
		$numColsData = count( $firstRow );
		for($i=0;$i<$rowData;$i++)
		{
			unset($data[$i]);
		}
		for($i=$rowData;$i<$l;$i++)
		{
			if($data[$i])
				$data[$i] = '("'.str_replace("\t",'","', addslashes($data[$i]) ).'")';
			else unset($data[$i]);
		}
		$cols = explode(',',$cols);
		$numCols = count($cols);
		//if there is less data then sent columns, we fill only the first n columns
		for ($i=$numColsData;$i<$numCols;$i++ )
		{
			unset($cols[$i]);
		}
		$cols = implode(',',$cols);

		try {
			if(!$idCol)
			{	//if there is no ID row...we delete all data and insert this as new!
				$this->db->SQLexecute("TRUNCATE TABLE $this->table");
				$sql = "INSERT INTO $this->table ( $cols ) VALUES ".implode(',',$data);
					If (!$this->db->SQLexecute($sql)){echo '{"success":false,"error":"'.$this->db->GetError().'"}'; exit;}
			}
			else
			{ //else we update fields that have id and insert fields that don't...this will be fun with 200k records :D
				foreach (explode(',',$cols) as $col) {
					if($col != 'id')
						$dupId[] = $col. " = VALUES($col)";
				}

				$sql = "INSERT INTO $this->table ( $cols ) VALUES ".implode(',',$data).
				" ON DUPLICATE KEY UPDATE ".implode(',',$dupId);
					If (!$this->db->SQLexecute($sql)){echo '{"success":false,"error":"'.$this->db->GetError().'"}'; exit;}
			}
		}

		catch (Exception $e)
		{


			return "{success:false, error: 'Import error! Please check that number of columns match!',msg:".json_encode($e->getMessage())."}";
		}
		return "{success: true}";
	}
	public function importFileAction()
	{
		$fh = fopen($_FILES['csvfilepath']['tmp_name'], 'r');

		$struktura = trim(fgets($fh));
		$struktura = str_replace(array("'",'"','.',' '),'',$struktura);


		fclose($fh);
		//we read the line and column separator
		$lineSep = $_POST['lineSep'];
		$columnSep = stripslashes($_POST['columnSep']);

		//we detect the encoding of the file
		$fileEncoding = strtolower( mb_detect_encoding($struktura) );
		$sql = "SHOW CHARACTER SET WHERE Charset LIKE '$fileEncoding'";
		if(!$res = $this->db->SQLexecute($sql) ){echo '{"success":false,"error":"Error with charsets!"}'; exit; }
		if($row = $this->db->fetchAssoc($res))
		{//if the encoding matches one of the databases legal encoding we use it in the load querry
			$mysqlEncoding = $row['Charset'];
		}
		else
		{//otherwise we try to convert it

		//array to convert mb_detect_encoding values to mysql legal charset
			$encodTable['utf-8'] = 'UTF8';
			$encodTable['ascii'] = 'ascii';

			$mysqlEncoding = $encodTable[ $fileEncoding  ];
		}

		if(!$mysqlEncoding)
		{
			return '{"success":false,"error":"Unknown character set: '.$encLine.'!"}';
		}
		try {
		$this->db->SQLexecute("TRUNCATE TABLE $this->table");
		$sql = "LOAD DATA LOCAL INFILE '".$_FILES['csvfilepath']['tmp_name']."'
					INTO TABLE  ".DB_WARPIT_USERSPOOL.".".$this->table." CHARACTER SET '$mysqlEncoding' FIELDS TERMINATED BY '$columnSep' ENCLOSED BY '\"' LINES TERMINATED BY '$lineSep' IGNORE 1 LINES ($struktura) ";
		If (!$this->db->SQLexecute($sql)){echo '{"success":false,"error":"'.$this->db->GetError().'"}'; exit;}
		}
		catch (Exception $e)
		{
			return "{success:false, error: 'Import error! Please check that number of columns match!'}";
		}
		return "{success: true}";
	}


 protected function filtering($filter)
{
	 $srcfields = json_decode( stripslashes($_POST['srcfields'])  );
	$where = " 0=0 ";
	if (is_array($filter))
	{
		for ($i=0;$i<count($filter);$i++){
			$originalFilter = $filter[$i]['field'];
			if($filter[$i]['data']['RMtable']) $filter[$i]['field'] =  $filter[$i]['data']['RMtable'].'.'. $filter[$i]['field'];
			if($filter[$i]['data']['convertNull']) $filter[$i]['field'] = "IF(".$filter[$i]['field']." IS NULL,0,".$filter[$i]['field'].")";

			switch($filter[$i]['data']['type']){
				case 'string' : $qs .= " AND ".$filter[$i]['field']." LIKE '%".$filter[$i]['data']['value']."%'"; Break;
				case 'list' :
					if (strstr($filter[$i]['data']['value'],',')){
						$fi = explode(',',$filter[$i]['data']['value']);
						for ($q=0;$q<count($fi);$q++){
							$fi[$q] = "'".$fi[$q]."'";
						}
						$filter[$i]['data']['value'] = implode(',',$fi);
						$qs .= " AND ".$filter[$i]['field']." IN (".$filter[$i]['data']['value'].")";
					}else{
						$qs .= " AND ".$filter[$i]['field']." = '".$filter[$i]['data']['value']."'";
					}
				Break;
				case 'boolean' : $qs .= " AND ".$filter[$i]['field']." = ".($filter[$i]['data']['value']); Break;
				case 'numeric' :
					//IF (user_id IS NULL, 0, id_user) = 0
					switch ($filter[$i]['data']['comparison']) {
						case 'ne' : $qs .= " AND ".$filter[$i]['field']." != ".$filter[$i]['data']['value']; Break;
						case 'eq' : $qs .= " AND ".$filter[$i]['field']." = ".$filter[$i]['data']['value']; Break;
						case 'lt' : $qs .= " AND ".$filter[$i]['field']." < ".$filter[$i]['data']['value']; Break;
						case 'gt' : $qs .= " AND ".$filter[$i]['field']." > ".$filter[$i]['data']['value']; Break;
					}
				Break;
				case 'date' :
					switch ($filter[$i]['data']['comparison']) {
						case 'ne' : $qs .= " AND ".$filter[$i]['field']." != '".date('Y-m-d',strtotime($filter[$i]['data']['value']))."'"; Break;
						case 'eq' : $qs .= " AND ".$filter[$i]['field']." LIKE '".date('Y-m-d',strtotime($filter[$i]['data']['value']))."%'"; Break;
						case 'lt' : $qs .= " AND ".$filter[$i]['field']." < '".date('Y-m-d',strtotime($filter[$i]['data']['value']))."'"; Break;
						case 'gt' : $qs .= " AND ".$filter[$i]['field']." > '".date('Y-m-d',strtotime($filter[$i]['data']['value']))."'"; Break;
					}
				Break;
			}

			$filter[$i]['field'] = $originalFilter;

		}
		$where .= $qs;
	}
	if(is_array($srcfields))
	{
		$qr = $_POST['srcquery'];
		if ($qr) {
			foreach ($srcfields as $fld) {
					// soulskiner added 28.3.2014
				if (strtolower($fld) == "id") continue;
				// end added 28.3.2014

				if($fld === "a.id"){
					$srWh[] = $fld . " LIKE '%$qr%'";
				} else if(strpos($fld, '.') !== false) {
                    $srWh[] = $fld . " LIKE '%$qr%'";
				}else {
					$srWh[] = "`" . $fld . "` LIKE '%$qr%'";
				}
			}
			$where .= ' AND ('.implode(' OR ',$srWh).') ';
		}
	}
	return $where;

}

}


?>
