<?php

namespace Warpit\Services;

class DesignRendererService
{
    protected $designPath = '';

    protected $questions = null;

    protected $pluginSettingsLoader = null;

    protected $otherProperties = null;

    public function __construct($questions, $pluginSettingsLoader = null, $otherProperties = null)
    {
        $this->questions            = $questions;
        $this->pluginSettingsLoader = $pluginSettingsLoader;
        $this->otherProperties      = $otherProperties;
    }

    private function getQuestionContext()
    {
        $questionsContext = [];
        foreach($this->questions as $question){
            $questionsContext[] = [
                'name'         => $question->q_name,
                'type'         => $question->tip_sql,
                'questionText' => $question->vpr_sql,
                'instruction'  => $question->nav_sql,
                'leaveText'    => $question->getLeaveText(),
                'answers'      => $question->getAnswersArray(),
                'answersJSON'  => $question->getAnswersJson(),
            ];
        }

        return $questionsContext;
    }

    private function getSupportContext()
    {
        return [
            'recordId'   => $_SESSION['id_record'],
            'pathToRoot' => PATH_TO_ROOT,
            'position'   => $this->otherProperties['position'],
        ];
    }

    private function getPluginContext()
    {
        if($this->pluginSettingsLoader === null){
            return null;
        }

        return $this->pluginSettingsLoader->load();
    }

    public function setDesignPath($designPath)
    {
        $this->designPath = $designPath;
    }

    public function render($fileName)
    {
        $context['plugin']    = $this->getPluginContext();
        $context['support']   = $this->getSupportContext();
        $context['questions'] = $this->getQuestionContext();

        return view($fileName, $context, $this->designPath);
    }
}
