<?php

namespace Warpit\Console;

class Job
{
    protected $schedule = '* * * * *';

    protected $logFile = '';

    protected $closure = null;

    public function __construct()
    {
        $this->configure();
    }

    protected function configure()
    {
        throw new \Exception('Not implemented');
    }

    public function run()
    {
        throw new \Exception('Not implemented');
    }

    public function setSchedule($expression)
    {
        $this->schedule = $expression;
        return $this;
    }

    public function daily()
    {
        return $this->setSchedule('0 0 * * * *');
    }

    public function everyMinute()
    {
      return $this->setSchedule('* * * * * *');
    }

    public function everyFiveMinutes()
    {
        return $this->setSchedule('*/5 * * * * *');
    }

    public function everyTenMinutes()
    {
        return $this->setSchedule('*/10 * * * * *');
    }

    public function setLogFile($filename)
    {
        $this->logFile = $filename;
        return $this;
    }


}
