<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;


class UpdatePasswordCommand extends Command
{

    protected $usernames = [];

    public function __construct(\db $db)
    {
        $this->db = $db;

        parent::__construct();
    }

    protected function configure()
    {
      $this
        ->setName('warpit:update-password')
        ->setDescription('Update default passwords on this server')
        ->setHelp('This command allows you to update default passwords with current server\'s salt')
        ->setHidden(true)
        ;

        global $db;

        $this->db = $db;
    }
    protected function loadUsers()
    {
        $selectUsers = "SELECT id,username FROM " . DB_WARPIT_MAIN . "._user";
        $res = $this->db->SQLexecute($selectUsers);

        while($row = $this->db->fetchAssoc($res))
          $this->usernames[$row['username']] = $row['id'] ;
    }

    protected function checkUsername($username)
    {
        if(!$this->usernames)
          $this->loadUsers();

        if($id = $this->usernames[$username])
            return $id;
        return false;

    }

    protected function updatePassword($user_id, $newPassword)
    {
        $updateSQL = "UPDATE " . DB_WARPIT_MAIN . "._user ";
        $updateSQL .= "SET password = '" . password_hash($newPassword, PASSWORD_DEFAULT) . "'";
        $updateSQL .= " WHERE id = " . $user_id;

        return $this->db->SQLexecute($updateSQL);
    }

    protected function randomPassword() {
        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $helper = $this->getHelper('question');
        $question = new Question('<question>Please enter username you want to change:</question>', '');
        $user_id = false;
        do
        {
            $user = $helper->ask($input, $output, $question);

            $user_id = $this->checkUsername($user);

            if(!$user_id)
              $output->writeln('<error>This user doens\'t exists</error>');

        }while(!$user_id);

        $question = new Question('<question>Please enter new password(empty for random):</question>', '');
        $question->setHidden(true);
        $question->setHiddenFallback(false);
        $password = $helper->ask($input, $output, $question);

        if(strlen($password))
        {
          $question = new Question('<question>Repete password:</question>', '');
          $question->setHidden(true);
          $question->setHiddenFallback(false);
          $repetePassword = $helper->ask($input, $output, $question);

          if($password != $repetePassword)
          {
              $output->writeln('<error>Passwords doesn\'t match!</error>');
              return;
          }
        }
        else
        {
            $password = $this->randomPassword();
            $output->writeln('<comment>Your new password is: </comment>' . $password);
        }

        $this->updatePassword($user_id, $password);
        $output->writeln('<info>Password seccessfully changed!</info>');

    }
}
