<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Warpit\Console\Utilities;
use Warpit\Services\WarpitInstallService;

class TestInstallationCommand extends Command
{
    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('warpit:check-installation')
            ->setDescription('Check warpit installation')
            ->setHelp('This command check if warpit is correctly installed');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $env = $this->warpitInstallService->loadConfig();

        
        if($this->warpitInstallService->configExists() === false){
            $output->writeln('<bg=yellow;options=bold>Config check failed</>');
            return 1;
        }

        global $db;
        
        $this->warpitInstallService->setDatabase($db);

        if($this->warpitInstallService->mainDatabaseExists($env['MAIN_DATABASE']) === false){
            $output->writeln('<bg=yellow;options=bold>Config database does not exists.</>');
            return 2;
        }

        if($this->warpitInstallService->databasesExists($env['MAIN_DATABASE']) === false){
            $output->writeln('<bg=yellow;options=bold>Database check failed</>');
            return 3;
        }

        if($this->warpitInstallService->filesExists($env['WEBPROJECTS_FOLDER']) === false){
            $output->writeln('<bg=yellow;options=bold>Files check failed</>');
            return 4;
        }
        
        if($this->warpitInstallService->crontabEntryExists() === false){
            $output->writeln('<bg=yellow;options=bold>Cronjob check failed</>');
            return 5;
        }


        $output->writeln('<fg=green>No problems found</>');
        return 0;
    }
}
