<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Warpit\Services\RecreateStructureService;

class RecreateStructureCommand extends Command
{
    public function __construct(RecreateStructureService $recreateStructureService)
    {
        $this->recreateStructureService = $recreateStructureService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('warpit:recreate-structure')
            ->setDescription('Recreate structure table from engine log')
            ->setHelp('This command recreate structure table from engine log')
            ->addArgument('engineLogTable', InputArgument::REQUIRED, 'Engine log table')
            ->addArgument('structureTable', InputArgument::REQUIRED, 'Structure table');
    }
    
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->recreateStructureService->recreateStructure($input->getArgument('engineLogTable'), $input->getArgument('structureTable'));
    }
}
