<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Question\ChoiceQuestion;
use Warpit\Console\Utilities;
use Warpit\Services\WarpitInstallService;
use SolveX\Support\Dotenv;

class InstallFilesCommand extends Command
{
    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('install:files')
            ->setDescription('Install warpit files')
            ->setHelp('This command create warpit files');
    }
    
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if($this->warpitInstallService->configExists() === false){
            $output->writeln('<bg=yellow;options=bold>Config check failed</>');
            return;
        }

        $env = $this->warpitInstallService->loadConfig();

        $this->warpitInstallService->createLiveUpdateFiles($env['WEBPROJECTS_FOLDER']);
        $this->warpitInstallService->unzipDesignFiles($env['WEBPROJECTS_FOLDER']);

        
        $output->writeln('<fg=green>Files created</>');

    }
}
