<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Warpit\Services\WarpitInstallService;

class InstallDatabaseCommand extends Command
{
    public function __construct(WarpitInstallService $warpitInstallService)
    {
        $this->warpitInstallService = $warpitInstallService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('install:database')
            ->setDescription('Install warpit databases')
            ->setHelp('This command create warpit databases');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if($this->warpitInstallService->configExists() === false){
            $output->writeln('<bg=yellow;options=bold>Config check failed</>');
            return;
        }

        $env = $this->warpitInstallService->loadConfig();

        $db = new \db;
        $db->SetDatabaseConnection($env['MYSQL_USER'], $env['MYSQL_PASS'], $env['MYSQL_HOST']);

        $this->warpitInstallService->setDatabase($db);

        $databasesExists = $this->warpitInstallService->databasesExists($env['MAIN_DATABASE']);
        if ($databasesExists === true) {
            $output->writeln('<bg=yellow;options=bold>Databases exists</>');
            return;
        }

        $this->warpitInstallService->createDatabase($env['MYSQL_USER'], $env['MYSQL_PASS'], $env['MYSQL_HOST'], $env['databases']);

        $output->writeln('<fg=green>Databases created</>');
    }
}
