<?php
/**
 * Created by PhpStorm.
 * User: Tanis
 * Date: 14. 08. 2018
 * Time: 10:32
 */

namespace Warpit\Console\Command;

use App\Services\WarpitConfigService;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;


class GenerateHashCommand extends Command
{
    protected function configure()
    {
        $this
            ->setName('password:hash')
            ->setDescription('Return password hash')
            ->setHelp('');

        $this->addArgument('password',InputArgument::REQUIRED, 'String you wanted to hash');
    }


    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $password = $input->getArgument('password');

        $hash = password_hash($password, PASSWORD_DEFAULT);
        $output->writeln('<info>Generated hash:</info>');
        $output->writeln($hash);
        $output->writeln('<info>Done!</info>');
    }

}