<?php 

class tgi
{
	public $db;
	protected $collectedProjectIDs = array();
	protected $orderProject;
	protected $TGIoption = array();
	
	public $activeProject;
	public $questOrder = array();
	public $enablePackets = array();
	public $startPoint;
	public $startPointLink;
	
	public function __construct($db)
	{
		$this->db=$db;
	}
	

	protected function getTGIoptions() {
		$sql = "SELECT * FROM ".DB_WARPIT_TGI.".TGI_options";
		$this->db->LogWrite($sql,true,"get TGI options");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			$option = $row['cValue'];
			if ($row['cName'] == "path_images") $option = str_replace("/","\\",$option);
			
			$this->TGIoption[$row['cName']] = $option; 
			$this->db->LogWrite(print_r($this->TGIoption,1),true,"TGI options...");
		}
		return true;
	}
	
	
	public function getActiveProject() {
		$row = $this->db->get("TGI_projects","active=1","id");
		$this->activeProject = $row[0];
		
		$this->db->LogWrite($this->activeProject,true,"get active project inside tgi class");
		
		return $this->activeProject;
	}
	

	public function getActiveQuestionnaireLinks($WarpitProjects,$idUser,$typeUser,$idTGIproject) {
		if (isset($WarpitProjects['ids'])) {
			$sql = "SELECT warpit_project,link AS loginSID FROM ".DB_WARPIT_TGI.".TGI_projects_links WHERE id_user=$idUser AND type_user=$typeUser AND TGI_project=$idTGIproject";
			$this->db->LogWrite($sql,true,"SQL get links for all questionnaires");
			$res = $this->db->SQLexecute($sql);
			while ($row = $this->db->fetchArray($res)) {
				$Qlinks[$row['warpit_project']] = $row['loginSID'];
			
				$this->db->LogWrite($row['warpit_project']." = ".$row['loginSID'],true,"get links for all questionnaires");
			}
			
			return $Qlinks;
		} else 
			return false;	
	}
	

	public function getWarpitProjects() {
		$sql = "SELECT a.*,b.proj_name FROM `TGI_warpit_projects` a
				LEFT JOIN ".DB_WARPIT_WEBCATI_BASE."._Projects b
				ON a.warpit_project=b.id
				WHERE a.TGI_project='".$this->activeProject."' 
				ORDER by project_order";
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchArray($res)) {
			$this->db->LogWrite($row['proj_name'],true,"get active warpit project names");
			$this->db->LogWrite($row['warpit_project'],true,"get active warpit project id");
			$this->db->LogWrite($row['C_name'],true,"get active warpit project HUMAN names");
			
			$WarpitProjects['name'][$row['warpit_project']] = $row['proj_name'];
			$WarpitProjects['C_name'][$row['warpit_project']] = $row['C_name'];
			$WarpitProjects['ids'][$row['warpit_project']] = $row['warpit_project'];
		}
		
		return $WarpitProjects;
	}
	
	/*
	 * Main function for creating warpit tables
	 */
	public function createWarpitTables($arrDDF,$storeAnswers,$storeQuestions,$language,$idActiveProject) {
		
		if ($this->buildTables($arrDDF,$storeAnswers,$storeQuestions,$language,$idActiveProject)) {
			if ($this->buildQuestions($arrDDF,$storeAnswers,$storeQuestions,$language,$idActiveProject)) {
				return true;
			} 
			else	
				return false;
		} 
		else
			return false;
	}
	
	
	protected function buildQuestions($arrDDF,$storeAnswers,$storeQuestions,$language,$idActiveProject=null) {
		//echo print_r($storeAnswers);
		$this->db->LogWrite(print_r($arrDDF,1),true,"TGI -> buildQuestions");
		/*		
		foreach ($arrDDF['03']['guide'] AS $item) {
			echo print_r($item)."\r\n";
		}
		*/
		$this->getTGIoptions();
		
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
		
		foreach ($arrDDF AS $questionnaire_cnt => $questions_array) {
			//echo "questionnaire_cnt:".$questionnaire_cnt."\r\n";
			
			$questionnaireCounter = $questionnaire_cnt;
			$QuestionnaireName = $questions_array['name'];
			
			//$QuestionnaireGuide = $questions_array['guide'];
			//echo "name --> ";
			//print_r($questions_array['name']);
			//echo "guide --> ";
			//print_r($questions_array['guide']);
			
			if (isset($questions_array['question'])) {
				$positionCounter = 1;
				foreach ($questions_array['question'] AS $questions => $questionProperty) {
					unset($Qlegend_arr);
					unset($TGIlegend_arr);
					unset($Qanswers);
					unset($TGIcode);
					unset($TGIcode_arr);
					unset($Qlegend);
					unset($TGIlegend);
					unset($ifLegendAnswer);
					unset($Qanswers_arr);
					unset($TGIcode_arr);
					unset($filterAll);
					unset($filterInside);
					unset($Instructions); // Borut: 2015.03.15
					unset($questionFilter);
					unset($answerGroup);
					
					$questionName = $questions;
					$SquestionName = substr($questions,0,4);
					$type = $questionProperty['type']; 
					$subtype = $questionProperty['subtype'];
					$tmpSubtype = $subtype;
					$show = $questionProperty['show'];
					$Qlabel = $questionProperty['label'][0];
					$mustAnswer = $questionProperty['must_answer'];

					// if type = 5, this is info question, S type from ddf, I add this as instruction to each question in the same S
					if ($type == 5) $instruction_S = $Qlabel;
					
					//echo "questionName:".$questionName."\r\n";
					
					$matchAnswerCode = array_keys($storeQuestions,$questionName);
					//print_r($matchAnswerCode);
					
					foreach ($matchAnswerCode AS $keyword) {
						$filterAll = $questions_array['guide']['filter_all'][$keyword];
						$filterInside = $questions_array['guide']['filter_inside'][$keyword];
						
						// Borut: 2015.03.15
						$InstructionsKeywordPath = $questions_array['guide']['instructions'][$keyword];
						if (strlen($InstructionsKeywordPath) > 5) $InstructionsKeyword = $this->getInstructionContent($InstructionsKeywordPath);

						if ($filterAll) {
							if ($questionFilter) $questionFilter .= " AND ";
							$questionFilter .= "(".$filterAll.")";
						}
						if ($filterInside) {
							if ($questionFilter) $questionFilter .= " AND ";
							$questionFilter .= "(".$filterInside.")";
						}
						
						// Borut: 2015.03.15
						if ($InstructionsKeyword) {
							if ($Instructions) $Instructions .= "<br><br>";
							$Instructions .= $InstructionsKeyword;
						}
						unset($InstructionsKeywordPath);
						unset($InstructionsKeyword);
						
						//echo "keyword:".$keyword." -> questionName:".$questionName." -> filterAll:".$filterAll." ->  filterInside:".$filterInside." ==> questionFilter:".$questionFilter." -> Instructions:".$Instructions."\r\n";
					}
					$this->db->LogWrite("questionFilter:".$questionFilter,true,"TGI -> warpit setting question filter");

					
					if ($type == 1 OR ($type == 3 AND $subtype == 1) OR $type == 5) {
						
						$answerCounter = 1;
						$colCounter = 0;
						if (isset($questionProperty['answers'])) {
							// samo za export si nastavim verjeten subtype, da je dropdown
							if ($type == 1 AND count($questionProperty['answers']['visible']) > 20) $tmpSubtype = 2;
							
							foreach ($questionProperty['answers'] AS $answerKey => $answerItem) {
								if ($answerKey != "visible") {
									$Qanswers_arr[] = $answerCounter." ".$answerItem[0];

									if ($type == 1) {
										$columnANDcondition[$answerKey] = "==".$answerCounter;
									} elseif ($type == 3) {
										$columnANDcondition[$answerKey] = "_".$answerCounter."==".$answerCounter;
									}
									
									//$TGIcode_arr[] = $answerCounter.":".$answerKey;
									$TGIcode_arr[] = "(".$idActiveProject.",'".$QuestionnaireName."', '".$questionName."', ".$answerCounter.", ".$colCounter.", '".$answerKey."', ".$type.", '".$tmpSubtype."')";
									
									$answerCounter++;
								}
							}
							if ($type == 1 AND count($Qanswers_arr)>20) $subtype = 2;
						}
						if (isset($Qanswers_arr)) {
							$Qanswers = implode("/",$Qanswers_arr);
							//$TGIcode = implode(",",$TGIcode_arr);
						}	
						
					} elseif (($type == 2 AND $subtype == 1) OR ($type == 3 AND $subtype == 4)) {
						// if I MBRX the whole grid, I checked here
						if ($questions_array['guide'][$SquestionName]['show_grid'][$questionName]) {
							echo "I need to merge legend backup and show this grid\n";
							
						}
						
						$legendCounter = 1;
						if (isset($questionProperty['legend'])) {
							foreach ($questionProperty['legend'] AS $legendKey => $legendItem) {
								if ($legendItem['hide'] != 1 AND isset($legendItem['answers'])) $Qlegend_arr[] = $legendCounter." ".$legendItem[0];
								//echo "legend counter in item (key=$legendKey)=".$legendCounter." - ".$legendItem[0]."\n";
								
								$answerCounter = 1;
								if (isset($legendItem['answers'])) {
									foreach ($legendItem['answers'] AS $answerKey => $answerItem) {
										if ($legendCounter == 1) $Qanswers_arr[] = $answerCounter." ".$answerItem[0];
										
										if ($type == 2) {
											$columnANDcondition[$answerKey] = "_".$answerCounter.">0";
										} elseif ($type == 3) {
											$columnANDcondition[$answerKey] = "_".$answerCounter."_".$legendCounter."==".$legendCounter;
										}
										//$TGIcode_arr[] = $answerCounter.":".$answerKey; 
										$TGIcode_arr[] = "(".$idActiveProject.",'".$QuestionnaireName."', '".$questionName."', ".$answerCounter.", ".$legendCounter.", '".$answerKey."', ".$type.", '".$subtype."')";
										
										$answerCounter++;
									}
								}
								if (isset($Qanswers_arr)) {
									$Qanswers = implode("/",$Qanswers_arr);
								}	
									
								$TGIlegend_arr[] = $TGIcode;
								
								if ($legendItem['hide'] != 1 AND isset($legendItem['answers'])) $legendCounter++;
							}
						}
						
						if (isset($Qlegend_arr)) {
							$Qlegend = implode("/",$Qlegend_arr);
						}	
						if (isset($TGIlegend_arr)) {
							$TGIlegend = implode(";",$TGIlegend_arr);
						}	
						
					}
					;
					$this->db->LogWrite(print_r($TGIcode_arr,1),true,"TGI -> TGIcode_arr for export CSV");
					
					// because for ddf I get no $ infront of variable, I am adding this
					$questionFilter = $this->addDolarToVariables($questionFilter);
					//echo "questionFilter:$questionFilter\r\n";
					$this->db->LogWrite("questionFilter:".$questionFilter,true,"TGI -> warpit setting question filter after dolar");
					
					$forReplace = $this->getForReplace($questionFilter);
					//print_r($forReplace)."\r\n";
					
					$questionFilter = $this->change2WarpitVariables($questionFilter,$forReplace,$storeQuestions,$columnANDcondition,$QuestionnaireName,$storeAnswers);
					//echo "1. questionFilter:$questionFilter\r\n";
					$this->db->LogWrite("questionFilter:".$questionFilter,true,"TGI -> warpit setting question filter after replace variables");
					
					$this->db->LogWrite($QuestionnaireName,true,"Questionnaire name");
					$this->db->LogWrite($questionnaireCounter,true,"Questionnaire counter");
					$this->db->LogWrite($questionName,true,"Question name");
					$this->db->LogWrite($SquestionName,true,"S Question name");
					$this->db->LogWrite($type,true,"Question type");
					$this->db->LogWrite($subtype,true,"Question subtype");
					$this->db->LogWrite($show,true,"Question show");
					$this->db->LogWrite($mustAnswer,true,"Must answer");
					$this->db->LogWrite($Qlabel,true,"Question label");
					$this->db->LogWrite($Qanswers,true,"Question answer");
					$this->db->LogWrite($Qlegend,true,"Question legend answer");
					$this->db->LogWrite($TGIcode,true,"TGI -> warpit answer codes");
					$this->db->LogWrite($TGIlegend,true,"TGI -> warpit legend answer codes");
					$this->db->LogWrite($questionFilter,true,"TGI -> warpit question filter");
					$this->db->LogWrite("\n\n",true,"");
					
					
					// I must do a dirty fix for multi
					// in both cases I have type=3 and subtype=4 (checkboxes), but I set subtype for simple multi = 1 (like radiobuttons)
					// (this is wrong, I must fix it now)
					// I did because I must do different things, if it is simple multi or multi with legend
					// I change back now to correct subtype 
					if ($type == 3 AND $subtype == 1) $subtype = 4;
					
					
					// use also options from config table for TGI
					// at the moment I have only hide question option
					$disableQuestion = 0;
					if ($type == 5 AND $this->TGIoption['show_info_question'] == 0) $disableQuestion = 1;
					
					
					// build also answers groups, if I need to add legend in the middle of answers
					if ($type == 2 OR ($type == 3 AND $subtype == 4)) $answerGroup = $this->createAnswerGroup($Qanswers,$this->TGIoption['MinMax_scale_answers']);
					
					
					if ($show == 1) {
						$sql = "INSERT INTO `".$QuestionnaireName."` (`id`,`q_pos`,`q_name`,`tip_sql`,`les_sql`,`open_sql`,`must_answer`,`fil_sql`,`disable_question`,`answerGroups`) VALUES 
																 (null, $positionCounter, '".$questionName."', ".$type.", '".$subtype."', 1, ".$mustAnswer.", '".$questionFilter."', '".$disableQuestion."', '".$answerGroup."')";
						$this->db->SQLexecute($sql);
						$this->db->LogWrite($sql,true,"fill quest table with new question");		
						$id_question = $this->db->GetLastInsertId();
						
						$sql = "INSERT INTO `".$QuestionnaireName."_tree` (`id`,`id_sup`,`id_question`,`orderBy`,`idLab`,`is_leaf`,`showTogether`) VALUES 
																 (".$id_question.", 0, '".$id_question."', ".($positionCounter-4).", '".$questionName."', 1, 0)";
						$this->db->SQLexecute($sql);
						$this->db->LogWrite($sql,true,"fill tree table with new question");		
						
						
						// Borut: 2015.03.15
						// set instructions from guide definition or set from for the whole complex for S definiton
						unset($tmpInstruction);
						if ($type != 5) $tmpInstruction = $instruction_S;
						if ($Instructions) {
							if ($tmpInstruction) 
								$tmpInstruction .= "<br><br>".$Instructions;
							else {
								$tmpInstruction = $Instructions;
							}
						}
						if ($tmpInstruction) {
							$addInstructionS = ",(null, ".$language[0].", '".$id_question."', 1, '".addslashes($tmpInstruction)."')";
							//echo $addInstructionS;
						}
						// upper part replacing the two bottom lines for adding the instructions to the question
						//if ($type != 5) $addInstructionS = ",(null, ".$language[0].", '".$id_question."', 1, '".addslashes($instruction_S)."')";
						//if ($Instructions) $ifInstruction = ",(null, ".$language[0].", '".$id_question."', 1, '".addslashes($Instructions)."')";
						if ($Qlegend) $ifLegendAnswer = ",(null, ".$language[0].", '".$id_question."', 4, '".addslashes($Qlegend)."')";
						
						$sql = "INSERT INTO `".$QuestionnaireName."_language` (`id`,`id_language`,`id_question`,`id_text_type`,`lngText`) VALUES
																  (null, ".$language[0].", '".$id_question."', 2, '".addslashes($Qlabel)."')
																 ,(null, ".$language[0].", '".$id_question."', 3, '".addslashes($Qanswers)."')"
																 .$addInstructionS.$ifLegendAnswer;
						$this->db->SQLexecute($sql);
						$this->db->LogWrite($sql,true,"fill language table with new labels");		
						unset($addInstructionS);
						
						// zapisem se definicijo za export
						if (count($TGIcode_arr)>0) {
							$sql = "INSERT INTO ".DB_WARPIT_TGI.".`TGI_projects_export` (`TGI_project`, `warpit_project`, `warpit_question`, `warpit_code`, `column_count`, `TGI_code`, `qType`, `qSubType`) VALUES 
																".implode(",",$TGIcode_arr);
							$this->db->LogWrite($sql,true,"fill export table with definition");		
							$this->db->SQLexecute($sql);
						}
						
						$positionCounter++;
					}
				}
			}
			
			// disable _start question and add redirection script to _end questions
			$sql = "UPDATE `".$QuestionnaireName."` SET `disable_question`=1 WHERE q_name='_Start'";
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"Update _Start and disable it");		
			$sql = "INSERT INTO `".$QuestionnaireName."_language` SET id_language=125, id_question=2, id_text_type=2, lngText='Zaključili ste sklop.'";
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"Update _End");		
			
			
			$scriptIsert = "include_once(PATH_TO_ROOT.\"/TGI/_class/class.tgi.php\");\r\n";
			$scriptIsert .= "\$tgiQuest = new tgi(\$db);\r\n";
			$scriptIsert .= "\$tgiDatabse = \$tgiQuest->getTGIdatabase();\r\n";
			$scriptIsert .= "\$propertyTGI = \$tgiQuest->getTGIproperty4warpitProject(\$_SESSION[\'id_project\'],\$tgiDatabse);\r\n";
			$scriptIsert .= "\$tgiQuest->setDonePct(\$tgiDatabse,\$_SESSION[\'id_project\'],\$_SESSION[\'id_loginSID\']);\r\n";
			$scriptIsert .= "\$link = \$tgiQuest->calculateNewLink(\$propertyTGI,\$_SESSION[\'id_loginSID\'],\$tgiDatabse);\r\n";
			$scriptIsert .= "if (\$link != false) {\r\n";
			$scriptIsert .= "    \$linkPre = WARPIT_WWW.\"survey/index.php?TGIclient=1&loginSID=\";\r\n";
			$scriptIsert .= "    \$linkAdd = \"&structurePreDef=\".\$_SESSION[\'id_record\'];\r\n";
			$scriptIsert .= "    \$tgiQuest->setNewQuestID(\$tgiDatabse,\$_SESSION[\'id_loginSID\']);\r\n";
			$scriptIsert .= "    echo \$tgiQuest->redirect2newQuest(\$linkPre.\$link.\$linkAdd);\r\n";
			$scriptIsert .= "}";
			
			$sql = "INSERT INTO `".$QuestionnaireName."_script` SET script='$scriptIsert', id_question=2, id_event=2";
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"Insert script into _Start");		
			
		}

		include_once (PATH_TO_ROOT.'_class/createQuestion/Question.php');		
		$structure = new bqwcGridDataMan($this->db,null);
		$_POST['action'] = "createStructure";
		$_POST['deleteConfirm'] = true;
		$_POST['id_project'] = implode(",",$this->collectedProjectIDs);
		$structure->createStructureAction();
		
		return true;
	}
	
	
	protected function getInstructionContent($file) {
		$path = WARPIT_WEBPROJECTS."TGI/".$file;
		$html = file_get_contents($path);
		
		return $html;
	}
	
	
	protected function createAnswerGroup($Qanswers, $MinMax) {
		$this->db->LogWrite(print_r($Qanswers,1),true,"answerGroup inside createAnswerGroup, Qanswers");
		
		$minmax_arr = explode(":",$MinMax);
		$min = $minmax_arr[0];
		$max = $minmax_arr[1];
		
		$Qanswers = str_replace("</","<<*>",$Qanswers);
		$ans_arr = explode("/",$Qanswers);
		$cnt_ans = count($ans_arr);
		$this->db->LogWrite("min:$min - max:$max - count answers:$cnt_ans",true,"answerGroup, parameters");
		if ($cnt_ans <= $max) return null;
		
		
		/* else we continue to set repeat legend
		- delim z MAX stevilom
		- zaokrozim cifro na vzgor
		- delim s to novo cifro
		- zaokrozim
		- odgovore dam v grupe po tem zadnjem zaokrozku, na koncu ostane kar ostane (nikoli manj kot 6, ce je MAX>10)
		*/
		$group_num = ceil($cnt_ans / $max);
		$ans_grp_num = round($cnt_ans / $group_num);
		if ($ans_grp_num < $min) $ans_grp_num = $min;
		$this->db->LogWrite("answers per group:$ans_grp_num",true,"answerGroup");
		
		// example of answer_group --> 0,0,0,1,1,1,2,2<|><|>,,,1<*>,,,1<*>,,,1
		$i_grp = 0; // number of answer groups
		$j_ans_grp = 1; // number of answers per group
		$str_flag[] = ",,,1";
		for ($n=0;$n<$cnt_ans;$n++) {
			$str[] = $i_grp;
			
			if ($ans_grp_num >= $j_ans_grp) { 
				$j_ans_grp++;
			} else {
				$j_ans_grp = 1;
				$str_flag[] = ",,,1";
				$i_grp++;
			}
			
		}
		
		$repeatLegend_str = implode(",", $str)."<|><|>".implode("<*>", $str_flag);
		$this->db->LogWrite("repeat legend str:$repeatLegend_str",true,"answerGroup");
		
		return $repeatLegend_str;
	}
	
	
	protected function buildTables($arrDDF,$storeAnswers,$storeQuestions,$language,$idActiveProject) {
		$createUser = $_SESSION['UserInfo']['Firstname']." ".$_SESSION['UserInfo']['Surname'];
		$createTime = $_SESSION['UserInfo']['LastLogin'];
		
		
		$this->db->ChangeDatabase(DB_WARPIT_TGI);
		$sql = "DELETE FROM `TGI_warpit_projects` WHERE TGI_project=".$idActiveProject;
		$this->db->LogWrite($sql,true,"clear `TGI_warpit_projects`");		
		$this->db->SQLexecute($sql);
		
		$sql = "DELETE FROM `TGI_projects_links` WHERE TGI_project=".$idActiveProject;
		$this->db->LogWrite($sql,true,"clear `TGI_projects_links`");
		$this->db->SQLexecute($sql);
		
		$sql = "DELETE FROM `TGI_warpit_projects_users` WHERE TGI_project=".$idActiveProject;
		$this->db->LogWrite($sql,true,"clear `TGI_warpit_projects_users`");
		$this->db->SQLexecute($sql);
		
		$sql = "DELETE FROM `TGI_projects_order` WHERE TGI_project=".$idActiveProject;
		$this->db->LogWrite($sql,true,"clear `TGI_projects_order`");		
		$this->db->SQLexecute($sql);
		
		$sql = "DELETE FROM `TGI_projects_users` WHERE TGI_project=".$idActiveProject;
		$this->db->LogWrite($sql,true,"clear `TGI_projects_users`");		
		$this->db->SQLexecute($sql);
		
		$Project_cnt = 1;
		$buildOrder = array();
		foreach ($arrDDF AS $questions_array) {
			$name_project = $questions_array['name'];
			$language_project = $language[0];
			$name_project_human = $questions_array['sub_name'][0]; // vzamem privzeto prvi jezik iz DDFja
			
			$this->db->LogWrite($name_project."<->".$language_project."<->".$name_project_human,true,"name and language for project");
			try {
				// create new project and get ID, first remove the old one
				$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
				$id_arr = $this->db->get("`_Projects`","`proj_name`='$name_project'","id");
				$id_project_delete = $id_arr[0];
				
				$sql = "DELETE FROM `_Projects` WHERE id='".$id_project_delete."'";
				$this->db->SQLexecute($sql);
				$sql = "DELETE FROM `_ProjectsTree` WHERE id='".$id_project_delete."'";
				$this->db->SQLexecute($sql);
				$sql = "DELETE FROM `_LanguageProjects` WHERE id_project='".$id_project_delete."'";
				$this->db->SQLexecute($sql);
				$sql = "DELETE FROM `_www_externalLinks` WHERE id_project='".$id_project_delete."'";
				$this->db->SQLexecute($sql);
				$sql = "DELETE FROM `_www_ids` WHERE id_project='".$id_project_delete."'";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($id_project_delete,true,"project ID for delete");
								
				 
				$sql = "INSERT INTO `_Projects` (`id`,`key_proj`,`proj_name`,`language`,`naziv_proj`,`old`,`created`,`creat_name`,`modify`,`modi_name`,`start_date`,`end_date`,`rotation`,`id_capiTable`,`capi_reserve`,`set_use_autodial`,`predictive_work`,`predictive_numbers_tofind`,`predictive_overcall`,`isTemplate`,`id_select_layer`,`redirectActive`,`interview_show_variable`,`interview_show_ans_value`,`has_user_quotas`) VALUES
						(null,'-TGIwarpit','".$name_project."',".$language_project.",'','N','".$createTime."','".$createUser."','".$createTime."','".$createUser."','".$createTime."',FROM_UNIXTIME(".(time()+7776000)."),'N',0,0,0,0,0,0,0,0,0,0,0,0)";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"projects table");		
				
				$id_project = $this->db->GetLastInsertId();
				$sql = "UPDATE `_Projects` SET `key_proj`='".$id_project."-TGIwarpit' WHERE id=".$id_project;
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql." - id_project:".$id_project,true,"projects table key_proj");	
				$this->collectedProjectIDs[] = $id_project;
				
				$sql = "INSERT INTO `_ProjectsTree` (`id`,`id_sup`,`id_project`,`orderBy`,`idLab`,`is_leaf`) VALUES
						(".$id_project.",0,'".$id_project."',1,'".$name_project."',1)";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"projects Tree table");		
								
				$sql = "INSERT INTO `_LanguageProjects` (`id_language`,`id_project`) VALUES
						(".$language_project.",".$id_project.")";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"projects Language table");		
				
				
				for ($n=1;$n<=3;$n++) {
					$sql = "INSERT INTO `_www_externalLinks` (`id`,`id_project`,`linkType`) VALUES
							(null,".$id_project.",$n)";
					$this->db->SQLexecute($sql);
					$this->db->LogWrite($sql,true,"projects externalLinks table");	

					$link_id = $this->db->GetLastInsertId();
					$www_link = $this->randomLinks()."-".$link_id;
					$sql = "UPDATE `_www_externalLinks` SET `loginSID`='".$www_link."' WHERE id=".$link_id;
					$this->db->SQLexecute($sql);
					$this->db->LogWrite($sql,true,"projects www_ids update link");
				}
				
				
				$sql = "INSERT INTO `_www_ids` (`id`,`id_user`,`user_type`,`id_project`,`id_site`) VALUES
						(null,0,3,".$id_project.",0)";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"projects www_ids table");
				
				$link_id = $this->db->GetLastInsertId();
				$www_link = $this->randomLinks()."-".$link_id;
				$sql = "UPDATE `_www_ids` SET `loginSID`='".$www_link."' WHERE id=".$link_id;
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"projects www_ids update link");
								
				
				$this->db->ChangeDatabase(DB_WARPIT_TGI);
				// create connection between TGI project and warpit projects
				$sql = "INSERT INTO `TGI_warpit_projects` SET warpit_project=".$id_project.", TGI_project=".$idActiveProject.", project_counter=".$Project_cnt.", project_order=".$Project_cnt.", C_name='".$name_project_human."'";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"create connection between TGI project and warpit projects");		
				
				
				
				$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
				
				$sql = "DROP TABLE IF EXISTS `$name_project`";
				$this->db->SQLexecute($sql);
				
				$sql = "CREATE TABLE IF NOT EXISTS `$name_project` (
					  `id` int(5) NOT NULL AUTO_INCREMENT,
					  `q_pos` int(5) NOT NULL,
					  `q_name` char(20) COLLATE utf8_unicode_ci NOT NULL,
					  `tip_sql` int(2) DEFAULT NULL,
					  `drg_sql` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `les_sql` int(2) DEFAULT NULL,
					  `goto_sql` text COLLATE utf8_unicode_ci NOT NULL,
					  `fil_sql` text COLLATE utf8_unicode_ci NOT NULL,
					  `con_sql` text COLLATE utf8_unicode_ci NOT NULL,
					  `open_sql` int(2) DEFAULT NULL,
					  `anno_sql` int(2) DEFAULT NULL,
					  `attachAnswers` int(11) DEFAULT NULL,
					  `attachFalse` tinyint(1) DEFAULT NULL,
					  `rot_sql` text COLLATE utf8_unicode_ci,
					  `srot_sql` int(1) DEFAULT NULL,
					  `erot_sql` int(1) DEFAULT NULL,
					  `srotLegend` int(1) DEFAULT NULL,
					  `erotLegend` int(1) DEFAULT NULL,
					  `srotAttributes` int(1) DEFAULT NULL,
					  `erotAttributes` int(1) DEFAULT NULL,
					  `qrot_sql` char(9) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `id_style` int(8) DEFAULT NULL,
					  `must_answer` tinyint(1) NOT NULL DEFAULT '1',
					  `disable_question` tinyint(1) NOT NULL DEFAULT '0',
					  `answers_filter` tinyint(1) NOT NULL DEFAULT '0',
					  `variableTypeBase` tinyint(1) NOT NULL DEFAULT '4',
					  `variableTypeOpen` tinyint(1) NOT NULL DEFAULT '0',
					  `open_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `open_legend` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `open_attributes` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `multi_nogo_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
					  `multilanguage_all` text COLLATE utf8_unicode_ci,
					  `qleave_js_alert` tinyint(1) NOT NULL DEFAULT '0',
					  `filter_answer` text COLLATE utf8_unicode_ci,
					  `filter_legend` text COLLATE utf8_unicode_ci,
					  `filter_attributes` text COLLATE utf8_unicode_ci,
					  `hasStructure` tinyint(4) DEFAULT '0',
					  `use_for_quotas` tinyint(1) DEFAULT '0',
					  `isFinal` tinyint(1) DEFAULT '0',
					  `id_showTogether` int(11) NOT NULL DEFAULT '0',
					  `answerGroups` text COLLATE utf8_unicode_ci,
					  `legendGroups` text COLLATE utf8_unicode_ci,
					  `id_plugin` int(11),
					  `id_incentive` int(11),
					  `old_id` int(11) NOT NULL,
					  `up_down_rotchk` int(11) NOT NULL,
					  `up_down_rotvar` int(11) NOT NULL,
					  `repeat_legend` int(11) NOT NULL,
					  `autoSubmit` tinyint(1) NOT NULL default 0,
					  `missing_values` char(100) NULL,
					  PRIMARY KEY (`id`),
					  INDEX `tip_sql` (`tip_sql`),
					  INDEX `q_pos` (`q_pos`),
					  UNIQUE KEY `q_name` (`q_name`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"quest table");		
				
				$sql = "INSERT INTO `$name_project` (`id`,`q_pos`,`q_name`,`tip_sql`,`goto_sql`,`hasStructure`) VALUES
													(1, -6, '_Start', 5, 'true#1', 1),
													(2, -5, '_End', 5, '', 1),
													(3, -15, '_notAllow', 5, '', 1),
													(4, -16, '_notActive', 5, '', 1)";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"fill quest table with defaults");		
				
		
				$sql = "DROP TABLE IF EXISTS `".$name_project."_tree`";
				$this->db->SQLexecute($sql);
				
				$sql = "CREATE TABLE IF NOT EXISTS `".$name_project."_tree` (
					  `id` int(3) NOT NULL AUTO_INCREMENT,
					  `id_sup` int(5) NOT NULL,
					  `id_question` int(5) NOT NULL,
					  `orderBy` tinyint(3) NOT NULL,
					  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
					  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
					  `is_leaf` tinyint(1) NOT NULL,
					  `showTogether` tinyint(1) NOT NULL,
					  PRIMARY KEY (`id`),
					  INDEX `id_question` (`id_question`),
					  INDEX `orderBy` (`orderBy`),
					  INDEX `is_leaf` (`is_leaf`),
					  INDEX `id_sup` (`id_sup`) 
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"quest tree table");		
				
				
				$sql = "DROP TABLE IF EXISTS `".$name_project."_language`";
				$this->db->SQLexecute($sql);
				
				$sql = "CREATE TABLE IF NOT EXISTS `".$name_project."_language` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `id_language` int(11) NOT NULL,
					  `id_question` int(11) NOT NULL,
					  `id_text_type` int(11) NOT NULL,
					  `lngText` text COLLATE utf8_unicode_ci NOT NULL,
					  PRIMARY KEY (`id`),
					  UNIQUE KEY `qlt_index` (`id_language`,`id_question`,`id_text_type`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"quest language table");		
				
				
				$sql = "DROP TABLE IF EXISTS `".$name_project."_script`";
				$this->db->SQLexecute($sql);
				
				$sql = "CREATE TABLE IF NOT EXISTS `".$name_project."_script` (
					  `id_question` int(11) NOT NULL,
					  `id_event` int(11) NOT NULL,
					  `script` text COLLATE utf8_unicode_ci NOT NULL,
					  PRIMARY KEY (`id_question`,`id_event`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
				$this->db->SQLexecute($sql);
				$this->db->LogWrite($sql,true,"quest script table");
					
			} catch(Exception $e) {
				echo 'Message: '.$e->getMessage();
				return false;
			}
			$buildOrder[] = $Project_cnt;
			$Project_cnt++;
		}

		$packetBuild = $buildOrder;
		$firstQuestionID = array_shift($packetBuild);
		$sql = "INSERT INTO ".DB_WARPIT_TGI.".`TGI_projects_order` (`id`,`TGI_project`,`order_string`, `enable_packet`) VALUES (null,$idActiveProject,'".implode("/",$buildOrder)."','".$firstQuestionID.">".implode("/",$packetBuild)."')";
		$this->db->LogWrite($sql,true,"insert `TGI_projects_order`");		
		$this->db->SQLexecute($sql);
		
		return true;
	}
	

	protected function addDolarToVariables($logicalString) {
		// add $ to first variable
		$findChar = false;
		$n = 0;
		//echo "filter length: $logicalString(".strlen($logicalString).")\r\n";
		// $n nastavim na 7 znakov ker sem predvidel da vec kot 7 ( ne bo nikoli...
		
		while ($n < strlen($logicalString) AND $findChar == false AND $n < 8) {
			//echo "n:$n -> findChar:$findChar -> ".strlen($logicalString)."\r\n";
			if (substr($logicalString,$n,1) != "(" ) {
				//echo "inside or not... :$n\r\n";
				
				$firstPart = substr($logicalString,0,$n);
				$secondPart = substr($logicalString,$n);
				$logicalString = $firstPart."$".$secondPart;
				
				//echo "firstPart:$firstPart -> secondPart:$secondPart\r\n";
				//echo "string: $logicalString\r\n";
				
				$findChar = true;
			}		 
			$n++;
		}
		
		// add also to other variables
		$logicalString = str_replace(array(" OR "," AND "),array("<OR>","<AND>"),$logicalString);
		$logicalString = str_replace(" ","",$logicalString);
		$logicalString = str_replace(">"," $",$logicalString);
		$logicalString = str_replace("<"," ",$logicalString);
		
		$logicalString = str_replace("$(((((((","((((((($",$logicalString);
		$logicalString = str_replace("$((((((","(((((($",$logicalString);
		$logicalString = str_replace("$(((((","((((($",$logicalString);
		$logicalString = str_replace("$((((","(((($",$logicalString);
		$logicalString = str_replace("$(((","((($",$logicalString);
		$logicalString = str_replace("$((","(($",$logicalString);
		$logicalString = str_replace("$(","($",$logicalString);
		
		return $logicalString;
	}
	
	
	protected function getForReplace($filterStr) {
		$filterStr = " ".$filterStr." ";
		//echo "before replace: $filterStr\r\n";
		$filterStr = str_replace(array("(",")","$"," AND "," OR ")," ",$filterStr);
		//echo "after replace: $filterStr\r\n";
		
		$arr = explode(" ",$filterStr);
		
		$clean_arr = array();
		foreach ($arr AS $item) {
			if ($item) $clean_arr[] = trim($item); 
		}
		
		return $clean_arr;
	}
	
	
	protected function change2WarpitVariables($qFil,$forReplace,$storeQuestions,$columnANDcondition,$QuestionnaireName,$storeAnswers) {
		$qFil = str_replace(array(")"),array(" )"),$qFil);
		
		//echo "filter: $qFil\r\n";
		//echo "keyword for replace: ".$forReplace[0]."\r\n";
		//echo "question: ".$storeQuestions[$forReplace[0]]."\r\n";
		
		foreach ($forReplace AS $item) {
									
			// adding other project info to filter, if needed
			unset($outherProject);
			$this->db->LogWrite($QuestionnaireName." != ".$storeAnswers[$item],true,"TGI -> check project variable");
			if ($QuestionnaireName != $storeAnswers[$item]) $outherProject = '{'.$storeAnswers[$item].'_structure}';
					
			
			$newItem = $storeQuestions[$item];
			// I should also add direct condition and direct column name (based on question type)
			//echo "1. qFil:$qFil----->item:$item<->$newItem:new item\r\n";
			$qFil = str_replace($item." ",$newItem.$outherProject.$columnANDcondition[$item]." ",$qFil);
			//echo "2. qFil:$qFil----->item:$item<->$newItem:new item\r\n"; 
		}
		
		return $qFil;
	}
	
	/*
	 * function create links for basic statistics, etc...
	 */
	protected function randomLinks() {
		$string = "abcdefghijklmnoprstuvzABCDEFGHIJKLMNOPRSTUVZ0123456789";
		for ($n=0;$n<15;$n++) {
			$seed = rand(0,53);
			$randomlink .= $string[$seed];
		}
		return $randomlink;
	}
	
	
	public function createQuestLink($idUser,$typeUser,$WarpitProjects,$idTGIproject) {
		// check if user already have link(s)
		$sql = "SELECT count(*) as N FROM ".DB_WARPIT_TGI.".TGI_projects_links 
				WHERE id_user=$idUser AND type_user=$typeUser AND TGI_project=$idTGIproject";
		$this->db->LogWrite($sql,true,"check if link exist");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchArray($res);
		
		// if I have no links yet...
		if ($row['N'] == 0) {
			$links = $this->generateTGIlinks($idUser,$typeUser,$WarpitProjects,$idTGIproject);
			
			$sql = "INSERT IGNORE INTO ".DB_WARPIT_TGI.".TGI_projects_links 
					(`id`,`TGI_project`,`warpit_project`,`id_user`,`type_user`,`id_link`,`link`) 
					VALUES ".implode(",", $links);
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"projects www_ids table");
			
			// fill also table for done %
			$done = $this->generateDone($idUser,$typeUser,$WarpitProjects,$idTGIproject);
			$sql = "INSERT IGNORE INTO ".DB_WARPIT_TGI.".TGI_warpit_projects_users 
					(`TGI_project`, `warpit_project`, `id_user`, `type_user`, `done`) 
					VALUES ".implode(",", $done);
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"fill TGI_warpit_projects_users");
			
			// make also startup point for this user
			// take care if warpit questionnaire rotation not start at 1 (this should be then adjusted with TGI_projects_order table)
			$sql = "INSERT IGNORE INTO ".DB_WARPIT_TGI.".TGI_projects_users 
					(`TGI_project`,`id_user`,`type_user`,`warpit_start_at`) 
					VALUES ($idTGIproject,$idUser,$typeUser,1)";
			$this->db->SQLexecute($sql);
			$this->db->LogWrite($sql,true,"starting fill for TGI_projects_users table");
			
		}
		
		return true;
	}
	
	
	protected function generateDone($idUser,$typeUser,$WarpitProjects,$idTGIproject) {
		foreach ($WarpitProjects['ids'] AS $item) {
			$this->db->LogWrite($item,true,"WarpitProjects");
			$values[] = "($idTGIproject,$item,$idUser,$typeUser,0)";
		}
		
		return $values;
	}	
		
	protected function generateTGIlinks($idUser,$typeUser,$WarpitProjects,$idTGIproject) {
		foreach ($WarpitProjects['ids'] AS $item) {
			$this->db->LogWrite($item,true,"WarpitProjects");
			$values[] = "(-1,4,$item,0,'0-$item')";
		}
		
		mysql_query("LOCK TABLES ".DB_WARPIT_WEBCATI_BASE."._www_ids WRITE",$this->db->SQLconnect);
		$sql = "INSERT IGNORE INTO ".DB_WARPIT_WEBCATI_BASE."._www_ids ( `id_user`, `user_type`, `id_project`, `id_site`, `loginSID` )  
					VALUES ".implode(',',$values);
		$this->db->LogWrite($sql,true,"space for unique links");
		$this->db->SQLexecute($sql);

		
		$sql = "SELECT id FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids WHERE id_user<0";
		$this->db->LogWrite($sql,true,"get IDs for reserved user");
		$res = $this->db->SQLexecute($sql);
		while($row = $this->db->fetchRow($res)) {
			$linkIDs[] = $row[0]; 
		}
				
		$sql = "UPDATE IGNORE ".DB_WARPIT_WEBCATI_BASE."._www_ids SET `id_site`=id, loginSID = CONCAT(SUBSTRING(md5(loginSID),1,15),'-',id), id_user=0 WHERE id_user<0";				
		$this->db->LogWrite($sql,true,"set unique links www_ids");
		$this->db->SQLexecute($sql);
		mysql_query("UNLOCK TABLES",$this->db->SQLconnect);
		
		
		//prepare links for return to set TGI link table
		// I should get here IDs of the link to fill also TGI table with the same loginSID
		$sql = "SELECT id,loginSID,id_project FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids WHERE id IN (".implode(",",$linkIDs).")";
		$this->db->LogWrite($sql,true,"get links for reserved user");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchArray($res)) {
			$sqlValues = "(null,$idTGIproject,".$row['id_project'].",$idUser,$typeUser,".$row['id'].",'".$row['loginSID']."')";
			$links[] = $sqlValues;
			$this->db->LogWrite($sqlValues,true,"generate SQL values for INSERT into TGI links");
		}
		
		return $links;
	}
	
	
	/*
	 * I prepare in table projects_order the sistem for enable
	 * example order_string = 1/2/3/4/5/6/7/8/9/10/11/12
	 * example enable_packet = 1>2/3/4;4>5/6/7/8/9/10;10>11/12
	 */
	public function getQuestOrder($idTGIproject) {
		$sql = "SELECT order_string,enable_packet FROM ".DB_WARPIT_TGI.".TGI_projects_order WHERE TGI_project=$idTGIproject";
		$this->db->LogWrite($sql,true,"get order of questionnaires");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchArray($res);
		
		// save order of questionnaires
		$this->questOrder = explode("/", $row['order_string']);
		
		// save enable packets 
		$pack_array = explode(";", $row['enable_packet']);
		foreach($pack_array AS $item_pack) {
			$tmp = explode(">", $item_pack);
			$enable[$tmp[0]] = explode("/",$tmp[1]);
		}
		$this->enablePackets = $enable;
		
		return true;
	}
	

	public function id2TGI_TGI2id($idTGIproject) {
		$sql = "SELECT warpit_project,project_counter FROM ".DB_WARPIT_TGI.".TGI_warpit_projects 
				WHERE TGI_project=$idTGIproject";
		$this->db->LogWrite($sql,true,"set index translation between warpit project and conter");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchArray($res)) {
			$translator['wproject'][$row['warpit_project']] = $row['project_counter'];
			$translator['pcounter'][$row['project_counter']] = $row['warpit_project'];
		}
		
		return $translator;
	}
	
	
	public function getUserDone($idTGIproject, $id_user, $type_user) {
		$sql = "SELECT warpit_project,done FROM ".DB_WARPIT_TGI.".TGI_warpit_projects_users 
				WHERE TGI_project=$idTGIproject AND id_user=$id_user AND type_user=$type_user";
		$this->db->LogWrite($sql,true,"get done % for curent user");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchArray($res)) {
			$userDone[$row['warpit_project']] = $row['done'];
		}
		
		return $userDone;
	}
	
	
	public function getStartingPoint($idTGIproject, $id_user, $type_user) {
		$sql = "SELECT warpit_start_at FROM ".DB_WARPIT_TGI.".TGI_projects_users WHERE TGI_project=$idTGIproject AND id_user=$id_user AND type_user=$type_user";
		$this->db->LogWrite($sql,true,"get starting point of questionnaires");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchArray($res);
		
		$this->startPoint = $row['warpit_start_at'];
		$this->startPointLink = $this->getLink($this->startPoint, $idTGIproject, $id_user, $type_user);
		
		return true;
	}
	
	
	protected function getLink($project_counter,$idTGIproject,$id_user,$type_user,$tgiDatabse=null) {
		if (!$tgiDatabse) $tgiDatabse = DB_WARPIT_TGI;
		$sql = "SELECT a . * , b.id_user, b.type_user, b.link as startLink
				FROM ".$tgiDatabse.".`TGI_warpit_projects` AS a
				LEFT JOIN ".$tgiDatabse.".TGI_projects_links AS b ON a.`warpit_project` = b.`warpit_project`
				WHERE a.`TGI_project` =".$idTGIproject."
				AND a.`project_counter` =".$project_counter." 
				AND b.id_user=".$id_user." AND b.type_user=".$type_user;
		$this->db->LogWrite($sql,true,"get link of questionnaire");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchArray($res);
				
		$startLink = $row['startLink'];
		
		return $startLink;
	}
	
	
	public function getStructureID($id_user,$user_type) {
		$predifine = 0; 
		if ($user_type == 1) $predifine = 9000000000;
		$this->db->LogWrite($id_user." --- ".$user_type,true,"get structure ID");
		return $predefine + $id_user;
	}
	
	
	public function getTGIproperty4warpitProject($id_WarpitProject,$tgiDatabse) {
		$sql = "SELECT TGI_project,project_counter,project_order,C_name 
				FROM ".$tgiDatabse.".`TGI_warpit_projects` WHERE warpit_project=$id_WarpitProject";
		$this->db->LogWrite($sql,true,"get TGI property at the end of each questionnaire");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		
		return $row;
	}
	
	
	public function calculateNewLink($prop,$linkID,$tgiDatabse) {
 		$userTGI = $this->getUserFrom_linkID($tgiDatabse,$linkID);
 		$this->db->LogWrite("id user:".$userTGI['id_user']." - type user:".$userTGI['type_user'],true,"in calculateNewLink function I got user");
		
		$sql = "SELECT a.`project_counter`,a.`TGI_project`,a.`project_order`,b.`done` 
				FROM ".$tgiDatabse.".`TGI_warpit_projects` AS a
				LEFT JOIN  ".$tgiDatabse.".`TGI_warpit_projects_users` AS b
				ON a.`TGI_project`=b.`TGI_project` AND a.`warpit_project`=b.`warpit_project` 
				WHERE a.`TGI_project`=".$prop['TGI_project']." 
					AND a.project_order>".$prop['project_order']." 
					AND b.`id_user`=".$userTGI['id_user']." 
					AND b.`type_user`=".$userTGI['type_user']."  
					AND b.`done`<100 
				ORDER BY project_order ASC LIMIT 1";
		$this->db->LogWrite($sql,true,"get next project to run and prepare new link");
		$res = $this->db->SQLexecute($sql);
		
		if ($this->db->NumRows($res)>0) {
			$row = $this->db->fetchAssoc($res);
			$this->activeProject = $row['TGI_project'];
			$this->orderProject = $row['project_order'];
			$link = $this->getLink($row['project_counter'],$prop['TGI_project'],$userTGI['id_user'],$userTGI['type_user'],$tgiDatabse);
			return $link;
		} else {
			return false;
		}
	}


	public function setDonePct($tgiDatabase,$id_WarpitProject,$linkID,$pct=100) {
 		$userTGI = $this->getUserFrom_linkID($tgiDatabase,$linkID);
 		$this->db->LogWrite("id user:".$userTGI['id_user']." - type user:".$userTGI['type_user'],true,"in setDonePct function I got user");
 		
		$sql = "UPDATE ".$tgiDatabase.".`TGI_warpit_projects_users` SET done=$pct 
				WHERE TGI_project IN (SELECT id FROM ".$tgiDatabase.".`TGI_projects` WHERE active=1) 
					AND warpit_project=".$id_WarpitProject." AND id_user=".$userTGI['id_user']." AND type_user=".$userTGI['type_user'];
		$this->db->LogWrite($sql,true,"set TGI done to 100%");
		$this->db->SQLexecute($sql);
	}
	
	
	public function getUserFrom_linkID($tgiDatabase,$linkID) {
		$sql = "SELECT id_user, type_user FROM ".$tgiDatabase.".TGI_projects_links WHERE id_link=$linkID";
		$this->db->LogWrite($sql,true,"get user connected to specific link");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		
		return $row;
	}
	

	public function setNewQuestID($tgiDatabse, $linkID) {
		$sql = "SELECT id_user, type_user FROM ".$tgiDatabse.".`TGI_projects_links` WHERE id_link=$linkID";
		$this->db->LogWrite($sql,true,"get TGI user for current interview");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		
		$sql = "UPDATE ".$tgiDatabse.".`TGI_projects_users` SET warpit_start_at=$this->orderProject 
				WHERE TGI_project=$this->activeProject AND id_user=".$row['id_user']." AND type_user=".$row['type_user'];
		$this->db->LogWrite($sql,true,"set new ID of next questionnaire for current user");
		$this->db->SQLexecute($sql);
	}
	

	public function getTGIdatabase(){
		$sql = "SELECT cValue FROM ".DB_WARPIT_MAIN.".`_WarpitConfig` WHERE prefix='tgi' AND cName='database'";
		$this->db->LogWrite($sql,true,"get TGI database name");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);

		return $row['cValue'];
	}
	
	
	public function redirect2newQuest($link){
		$redirectStr .= "<script>";
		    $redirectStr .= "function delayedRedirect(){";
		        $redirectStr .= "window.location = '".$link."'";
		    $redirectStr .= "}";
		    $redirectStr .= "parent.endQuestionnaireCall();";
		    $redirectStr .= "setTimeout('delayedRedirect()', 2000);";
		$redirectStr .= "</script>";

		return $redirectStr;
	}
}
	
?>