<?php

namespace App\ViewModel;

use SolveX\ViewModel\ThrowableViewModel;
use SolveX\ViewModel\Annotations as VM;
use SolveX\ViewModel\Annotations\DataType;
use SolveX\Interfaces\RequestInterface as Request;

use App\ViewModel\Annotations\QuestionType;

class QuestionViewModel extends ThrowableViewModel
{
    /**
     * @VM\Required
     * @VM\DataType(DataType::String)
     * @var string
     */
    public $projectName;

    /**
     * @VM\Required
     * @VM\DataType(DataType::String)
     * @var string
     */
    public $questionName;


    /**
     * @VM\Required
     * @VM\DataType(DataType::Int)
     * @var int
     */
    public $languageId;


    /**
     * @QuestionType({"SINGLE_RESPONSE"})
     * @var int
     */
    public $type;

}
