<?php
/**
 * Created by PhpStorm.
 * User: Tanis
 * Date: 30. 08. 2018
 * Time: 13:12
 */

namespace App\Transformers;


use App\Entities\BaseEntity;
use Illuminate\Support\Collection;

class BaseTransformer
{
    public function transform(Collection $data, $type)
    {
        if ($data->count() <= 0) {
            return null;
        }

        if ($data->count() === 1) {
            return BaseEntity::create($type,$data->first());
        }

        $dataArray = [];
        foreach ($data as $object) {
            $dataArray[] = BaseEntity::create($type,$object);
        }

        return $dataArray;
    }
}