<?php
namespace App\Traits;

use App\Support\Filter;

trait FilteringTrait
{
    public function addFilter(Filter $filter, $repostoryName)
    {
        $this->$repostoryName->addFilter($filter);
        return $this;
    }

    public function removeFiltering($repostoryName)
    {
        $this->$repostoryName->removeFiltering();

        return $this;
    }

    /**
     * Add filter that will be used only on first function call
     *
     * @param Filter $filter
     * @param string|int $repository repository name or repository index
     * @return $this
     */
    public function addOneTimeFilter(Filter $filter, $repository)
    {
        if (is_string($repository)) {
            $this->$repository->addOneTimeFilter($filter);
        }

        if (is_int($repository)) {
            $properties = get_object_vars($this);
            $properties = array_values($properties);

            $properties[$repository]->addOneTimeFilter($filter);
        }

        return $this;
    }
}

?>
