<?php
namespace App\Traits;

use App\Entities\Answer;

trait AnswersConvertTrait
{
    public function toArray($answersString)
    {
        if (!$answersString) {
            return [];
        }

        $answersString = $this->cleanAnswers($answersString);

        $ansArr = explode('<*>', $answersString);

        $ansArray = [];
        foreach ($ansArr as $ans) {
            $answer = new Answer;
            list($answer->id, $answer->label) = explode(' ', $ans, 2);

            $answer->id = (int) $answer->id;

            $ansArray[] = $answer;
        }
        return $ansArray;
    }

    public function toString(array $answers)
    {
        if (empty($answers)) {
            return null;
        }

        $ansArr = [];
        foreach ($answers as $answer) {
            $ansArr[] = "$answer->id $answer->label";
        }

        return implode('/', $ansArr);
    }

    private function cleanAnswers($str)
    {
        $str = str_replace("/", "<*>", $str);
        $str = str_replace("<<*>", "</", $str);
        $str = str_replace("<*>>", "/>", $str);
        $str = str_replace("<*> ", "/ ", $str);
        //let's clean newlines in fornt or after delimiter!
        $str = str_replace("\n<*>", "<*>", $str);
        $str = str_replace("<*>\n", "<*>", $str);
        return $str;
    }
}
