<?php

namespace App\Tests;

use PHPUnit\Framework\TestCase;
use App\Services\ProjectService;
use \Mockery as m;

class ProjectServiceTest extends TestCase
{
    public function setupMocks()
    {
        $this->projectRepository                = m::mock('App\Repositories\ProjectRepository');
        $this->warpitConfigService              = m::mock('App\Services\WarpitConfigService');
        $this->uniqueLinksService               = m::mock('App\Services\UniqueLinksService');
        $this->systemDefaultQuestionsRepository = m::mock('App\Repositories\SystemDefaultQuestionsRepository');
        $this->structureTableService            = m::mock('App\Services\StructureTableService');
    }

    public function test_get()
    {
        $this->setupMocks();

        $this->projectRepository->shouldReceive('getProject')->once()->andReturn((object)[
            'id' => 1,
            'proj_name' => 'testProject',
            'naziv_proj' => ''
        ]);

        $ps = new ProjectService(
            $this->projectRepository,
                                $this->warpitConfigService,
                                $this->uniqueLinksService,
                                $this->systemDefaultQuestionsRepository,
                                $this->structureTableService
        );

        $project = $ps->get('testProject');

        $this->assertInstanceOf('App\Entities\Project', $project);
        $this->assertSame(1, $project->id);
        $this->assertSame('testProject', $project->projectName);
        $this->assertSame('', $project->longProjectName);
    }
}
