<?php

namespace App\Support;

use SolveX\Interfaces\RequestInterface as Request;
use SolveX\ViewModel\DataSourceInterface as DSI;

class Warpit
{
    public function __get($name)
    {
        return new WarpitFakeObject($name);
    }
}

class WarpitFakeObject
{
     public function __construct($name)
     {
        $this->container = $container = new \Illuminate\Container\Container;
        $container->bind(SolveX\ViewModel\DataSourceInterface::class, WarpitRequest::class);
        $this->name = $name;
     }

     public function __call($funcName, $arguments)
     {
          $namespace = 'App\Controllers\V2\\';
          $class = ucfirst($this->name) . 'Controller';

          $instance = $this->container->make($namespace.$class);

          $this->container->instance(WarpitRequest::class, function() use($arguments){
              return new WarpitRequest($arguments);
          });

          /*$method = new \ReflectionMethod($namespace.$class, $funcName);
          $params = $method->getParameters();

          $paramsArray = [];
          $i = 0;
          foreach($params as $param){
            $paramsArray[$param->name] = $arguments[0];
          }*/
          //var_dump($funcName, $arguments,$params) ;exit;

          return $instance->$funcName();
     }
}

class WarpitRequest implements DSI
{
    public function __construct(array $params)
    {
          $this->params = $params;
    }

    public function has($key)
    {
        return in_array($key, $this->params);
    }

    public function get($key)
    {
        if($this->has($key)){
          return $this->params[$key];
        }

        throw new \RuntimeException('Missing request input: ' . $key);
    }


}
