<?php
namespace App\Support;


class Filtering
{
    protected $oneTimeFilters = [];

    protected $permanentFilters = [];

    protected function filterQueryBuilder(\Illuminate\Database\Query\Builder $query)
    {
        foreach($this->oneTimeFilters as $filter){
            $query->where($filter->field,$filter->operator, $filter->value);
        }

        foreach($this->permanentFilters as $filter){
            $query->where($filter->field,$filter->operator, $filter->value);
        }
    }

    protected function removeOneTimeFilters()
    {
        $this->oneTimeFilters = [];
    }

    public function filter($query)
    {
        if(is_a($query,'\Illuminate\Database\Query\Builder')){
            $this->filterQueryBuilder($query);
        }

        $this->removeOneTimeFilters();
    }

    public function addOneTimeFilter(Filter $filter)
    {
        $this->add($filter,'oneTimeFilters');
    }

    public function addFilter(Filter $filter)
    {
        $this->add($filter, 'permanentFilters');
    }

    protected function add(Filter $filter, $filterType)
    {
        array_push($this->$filterType, $filter);
    }
}