<?php

namespace App\Services;

use App\Repositories\StructureTableRepository;
use App\Entities\StructureColumn;

class StructureTableService
{
    public function __construct(
      StructureTableRepository $structureTableRepository,
      WarpitConfigService $warpitConfigService
      )
    {
        $this->structureTableRepository = $structureTableRepository;
        $this->warpitConfigService      = $warpitConfigService;
    }

    public function create($name)
    {
        $structureTable = $name . '_structure';
        $engineLogTable = $name . '___EngineLog';

        $baseColumns = $this->structureTableRepository->getBaseColumns();

        $this->structureTableRepository->create($structureTable, $baseColumns);

        $engineLogColumns = $this->structureTableRepository->getEngineLogColumns();
        $this->structureTableRepository->create($engineLogTable, $engineLogColumns);
    }

    public function delete($name)
    {
        $structureTable = $name . '_structure';
        $engineLogTable = $name . '___EngineLog';

        $engineBackup    = (int)$this->warpitConfigService->getConfig('backup', 'engine', 1);
        $structureBackup = (int)$this->warpitConfigService->getConfig('backup', 'structure', 1);

        if ($engineBackup === 1) {
            $this->structureTableRepository->backup($engineLogTable);
        } else {
            $this->structureTableRepository->drop($engineLogTable);
        }

        if ($structureBackup === 1) {
            $this->structureTableRepository->backup($structureTable);
        } else {
            $this->structureTableRepository->drop($structureTable);
        }
    }

    public function addColumns($name, array $columnsList)
    {
        $this->structureTableRepository->addColumns($name, $columnsList);
    }

    public function dropColumns($name, array $columnsList)
    {
        $this->structureTableRepository->dropColumns($name, $columnsList);
    }

    public function getColumns($name){
        $structureTable = $name . '_structure';
        return $this->structureTableRepository->getColumns($structureTable);
    }

    public function recreate($name)
    {
        $this->delete($name);
        $this->create($name);
    }
}
