<?php

namespace App\Services;


class SendMailService
{
    protected $mailSetService;

    protected $mailStatisticsService;

    protected $panelistService;

    public function __construct(MailSetService $mailSetService, MailStatisticsService $mailStatisticsService, PanelistService $panelistService)
    {
        $this->mailSetService        = $mailSetService;
        $this->panelistService       = $panelistService;
        $this->mailStatisticsService = $mailStatisticsService;
    }

    public function send($groupId, $templateId, $projectId = 0, $projectType = 0, $customFields = null)
    {
        $mailSetId = $this->mailSetService->create($groupId,$templateId, $projectId, $projectType, $customFields);
        $panelists = $this->panelistService->getFromGroup($groupId);

        $this->mailStatisticsService->create($mailSetId, $panelists);
    }

}