<?php

namespace App\Services\ProjectManager\Projects;

use App\Repositories\ProjectManager\Projects\NotActiveProjectRepository;
use App\Services\WarpitConfigService;
use Carbon\Carbon;

class NotActiveProjectService
{
    protected $notActiveProjectsRepository;

    protected $configService;

    public function __construct(NotActiveProjectRepository $notActiveProjectsRepository, WarpitConfigService $configService)
    {
        $this->notActiveProjectsRepository = $notActiveProjectsRepository;
        $this->configService = $configService;
    }

    public function get()
    {
        $unactiveAfter = $this->configService->getConfig('webcati','unactive_days', 14);

        $dt = Carbon::now();
        $minDate  = $dt->subDays($unactiveAfter)->toDateTimeString();

        return $this->notActiveProjectsRepository->get($minDate);
    }
}