<?php

namespace App\Services\ProjectManager\Projects;

use App\Repositories\ProjectManager\Projects\ExportTemplateRepository;
use App\Transformers\ExportTemplateTransformer;
use App\Exceptions\RuntimeException;

class ExportTemplateService
{
    protected $exportTemplateRepository = null;

    protected $transformer = null;

    public function __construct(ExportTemplateRepository $exportTemplateRepository, ExportTemplateTransformer $transformer)
    {
        $this->exportTemplateRepository = $exportTemplateRepository;
        $this->transformer = $transformer;
    }

    protected function parseVariablesString($variablesString)
    {
        $explodeVariables = explode('|',$variablesString);

        $variablesArray = [];
        $variablesArray['ids']             = explode(',', array_shift($explodeVariables));
        $variablesArray['systemColumns']   = explode(',', array_shift($explodeVariables));
        $variablesArray['telFolder']       = explode(',', array_shift($explodeVariables));
        $variablesArray['questionColumns'] = explode(',', array_shift($explodeVariables));

        return $variablesArray;
    }

    protected function extractFieldName($column)
    {
        $column = explode('.', $column);

        return array_pop($column);
    }

    protected function isNotDigit($value)
    {
        if($value === ''){
            return false;
        }

        return ctype_digit($value) === false;
    }

    public function getStructureColumns($variablesString, $excludeColumns = [])
    {
        $variablesArray = $this->parseVariablesString($variablesString);

        $variablesArray = array_merge($variablesArray['systemColumns'], $variablesArray['questionColumns']);

        $variablesArray = array_filter($variablesArray,[$this, 'isNotDigit']);
        $variablesArray = array_map([$this, 'extractFieldName'],$variablesArray);

        return array_diff($variablesArray,$excludeColumns);

    }

    public function getByHash($templateHash)
    {
        list($templateId) = explode('-', $templateHash);
        $template = $this->exportTemplateRepository->get($templateId);
        $template = $this->transformer->transform($template);

        if($template === null){
            throw new RuntimeException("Template with this hash doesn't exists", 400);
        }

        if($template->hash !== $templateHash){
            throw new RuntimeException("You don't have rights to access this", 400);
        }

        return $template;
    }

}