<?php

namespace App\Services\ProjectManager\Projects;

use App\Repositories\ProjectManager\Projects\ActiveProjectRepository;
use App\Services\WarpitConfigService;
use App\Traits\FilteringTrait;
use Carbon\Carbon;

class ActiveProjectService
{
    use FilteringTrait;

    protected $activeProjectsRepository;

    protected $configService;

    public function __construct(ActiveProjectRepository $activeProjectRepository, WarpitConfigService $configService)
    {
        $this->activeProjectsRepository = $activeProjectRepository;
        $this->configService = $configService;
    }

    public function get()
    {
        $unactiveAfter = $this->configService->getConfig('webcati','unactive_days', 14);

        $dt = Carbon::now();
        $minDate  = $dt->subDays($unactiveAfter)->toDateTimeString();
        return $this->activeProjectsRepository->get($minDate);
    }
}