<?php

namespace App\Services;

use App\Repositories\PanelistStatusLogRepository;
use App\Repositories\PanelistStatusRepository;

class PanelistStatusService
{
    protected $panelistStatusRepository;

    protected $panelistStatusLogRepository;

    public function __construct(PanelistStatusRepository $panelistStatusRepository,
                                PanelistStatusLogRepository $panelistStatusLogRepository)
    {
        $this->panelistStatusRepository    = $panelistStatusRepository;
        $this->panelistStatusLogRepository = $panelistStatusLogRepository;
    }

    public function insert($panelistId, $status)
    {
        $this->panelistStatusRepository->insert($panelistId, $status);
        $this->panelistStatusLogRepository->insert($panelistId, $status,0);
    }

    public function update($panelistId, $status)
    {
        $this->panelistStatusRepository->update($panelistId, $status);
        $this->panelistStatusLogRepository->insert($panelistId, $status, 0);
    }

    public function get($panelistId)
    {
        return $this->panelistStatusRepository->get($panelistId);
    }
}