<?php

namespace App\Repositories;

class UniqueLinksRepository extends BaseRepository
{
    public function insert($link)
    {
          return $this->webcatiBaseConnection->table('_www_ids')->insertGetId($link);
    }

    public function updateLoginSID($linkId, $newLoginSID)
    {
          $this
              ->webcatiBaseConnection
              ->table('_www_ids')
              ->where('id', $linkId)
              ->update(['loginSID' =>$newLoginSID]);
    }

    public function delete($linkId)
    {
        $this->webcatiBaseConnection
            ->table('_www_ids')
            ->where('id', $linkId)
            ->delete();
    }

    public function deletePopup($projectId)
    {
        $this->webcatiBaseConnection
            ->table('_www_ids')
            ->where('id_project', $projectId)
            ->where('user_type', 3)
            ->delete();
    }

    public function getLastUniqueLink($projectId)
    {
        return $this->webcatiBaseConnection
            ->table('_www_ids')
            ->where('id_project', $projectId)
            ->where('user_type', 4)
            ->orderBy('id_site', 'desc')
            ->select(['id_site','loginSID'])
            ->first();
    }
}
