<?php

namespace App\Repositories\ProjectManager\Projects;

use App\Repositories\BaseRepository;
use Carbon\Carbon;
use DBL;

class ActiveProjectRepository extends BaseRepository
{
    public function get($minDate)
    {
        $query = $this->webcatiBaseConnection->table('_Projects as p');
        $query->leftJoin(DBL::raw("(SELECT  * FROM (
                                    SELECT id_project, startDate 
                                    FROM _www_interviewer_statistics 
                                    ORDER BY id_project DESC) as x 
                                    GROUP BY x.id_project) as s"), 'p.id', '=', 's.id_project');
        $query->select(DBL::raw('p.id, p.proj_name, p.active, s.startDate,p.anonymization_datetime, p.created, creat_name'));

        $query->where('p.active', 1);
        $query->where('s.startDate', '>', $minDate);
        $query->where('p.end_date', '>', Carbon::now());
        $this->filter($query);

        return $query->get()->all();
    }
}