<?php

namespace App\Repositories;

use Carbon\Carbon;

class PanelistStatusLogRepository extends BaseRepository
{
    protected $table = '_InterviewerStatusesLog';

    /**
     * @param $panelistId
     * @param $status
     * @param $adminId
     */
    public function insert($panelistId, $status, $adminId)
    {
        $this
            ->webuserspool
            ->table($this->table)
            ->insert([
                'interviewer_id' => $panelistId,
                'definedStatus'  => $status,
                'definedDate'    => Carbon::now()->toDateTimeString(),
                'admin_id'       => $adminId,
            ]);
    }
}