<?php

namespace App\Repositories;

class PanelistRepository extends BaseRepository
{

      public function get($panelistId)
      {
        return $this
          ->webuserspool
          ->table('_Interviewer')
          ->where('id', $panelistId)
          ->get()
          ->first()
          ;
      }

      public function update($panelistId, $fields)
      {
          $this
            ->webuserspool
            ->table('_Interviewer')
            ->where('id', $panelistId)
            ->update($fields);
      }

      public function removeFromGroups($panelistId)
      {
          return $this
            ->webuserspool
            ->table('_group_link')
            ->where('id', $panelistId)
            ->delete();
      }

      public function addToGroup($panelistId, $groupId)
      {
        return $this
          ->webuserspool
          ->table('_group_link')
          ->insert(['id' => $panelistId, 'id_group' => $groupId])
          ;
      }

      public function getFromGroup($groupId)
      {
          return $this
              ->webuserspool
              ->table('_group_link as gl')
              ->leftJoin('_Interviewer as i', 'gl.id', '=', 'i.id' )
              ->where('gl.id_group', $groupId)
              ->get();
      }

      public function getFields()
      {
          return $this->webuserspool
              ->table('_InterviewerStructure')
              ->where('is_leaf', 1)
              ->select('field_name')
              ->orderBy('orderBy')
              ->get();
      }

      public function getFieldByName($field_name)
      {
          return $this->webuserspool
              ->table('_InterviewerStructure')
              ->select('id', 'field_name', 'field_type')
              ->where('field_name', $field_name)
              ->first();
      }

      public function getFieldLabels($field_id)
      {
          return $this->webuserspool
              ->table('user_input_labels')
              ->where('lab_field', $field_id)
              ->get()
              ->keyBy('lab_code');
      }

      public function getPoints($panelistId)
      {
            return $this
                ->webcatiBaseConnection
                ->table('_wwwPoints as a')
                ->leftJoin('_wwwPurpose as b', 'a.id_purpose', '=', 'b.id')
                ->leftJoin('_Projects as c', 'a.id_project', '=', 'c.id')
                ->where('a.id_user', $panelistId)
                ->where('a.deleted', 0)
                ->select(['a.id', 'a.id_user', 'a.webPoints', 'a.modificationDate', 'b.label', 'b.negative', 'c.proj_name'])
                ->get()
                ;
      }

}
