<?php

namespace App\Repositories\PanelManager\RedirectionsManager;

use App\Repositories\BaseRepository;
use Carbon\Carbon;
use DBL;

class ActiveProjectRepository extends BaseRepository
{
    public function get($minDate)
    {
        $query = $this->webuserspool->table('_RedirectProjects as p');
        $query->select(['*', 'idLab as proj_name', 'startTime']);
        $query->leftJoin('_RedirectProperties as rp', 'p.id', '=', 'rp.id');
        $query->leftJoin(DBL::raw('(SELECT id_project,startTime 
                                    FROM _RedirectEndLink 
                                    GROUP BY id_project 
                                    ORDER BY startTime DESC) as rel'), 'p.id', '=', 'rel.id_project');
        $query->where('p.deleted', 0);
        $query->where('rp.survey_close', 0);
        $query->where('rp.end_date', '>', Carbon::now());
        $query->where('rel.startTime', '>', $minDate);

        $this->filter($query);

        return $query->get()->all();
    }
}