<?php

namespace App\Entities;

class MultiResponse extends Question
{
    protected function __construct($question)
    {
        $this->dataType = 4;
        $this->showAs   = 1;
        $this->openSql  = 1;

        parent::__construct($question);
    }

    public function getStructureColumns()
    {
        if (!$this->answersArray) {
            throw new \Exeption('Answers array is not set!');
        }

        $i = 1;
        foreach ($this->answersArray as $answer) {
            $column = new StructureColumn;
            $column->name = $this->questionName . '_' . $i;
            $column->id   = $this->dataType;

            $this->structureColumns[] = $column;
            $i++;
        }

        return $this->structureColumns;
    }
}
