<?php

namespace App\Controllers\V2;

use App\Services\ProjectManager\Projects\ProjectListService;
use App\Transformers\ProjectsTransformer;

class ProjectsController
{
    protected $projectListService  = null;

    protected $projectsTransformer = null;

    public function __construct(ProjectListService $projectListService, ProjectsTransformer $projectsTransformer)
    {
        $this->projectListService  = $projectListService;
        $this->projectsTransformer = $projectsTransformer;
    }

    public function get()
    {
        $projectData = $this->projectListService->get();
        return $this->projectsTransformer->transform($projectData);
    }
}