<?php

namespace App\Controllers\V2;

use SolveX\Interfaces\RequestInterface as Request;
use App\Services\ProjectService;
use Response;

class ProjectController
{
    public function __construct(ProjectService $projectService)
    {
        $this->projectService = $projectService;
    }

    public function create(Request $request)
    {
        if ($request->has('name')) {
            $name       = $request->input('name');
            $languageId = $request->input('languageId');
            //TODO other prameters like subfolder username
            return $this->projectService->create($name, $languageId);
        }
        Response::abort(400, 'Invalid parameters!');
    }

    public function delete(Request $request)
    {
        $projectName = $request->input('projectName');

        return $this->projectService->delete($projectName);

        Response::abort(400, 'Invalid parameters!');
    }

    public function get(Request $request)
    {
        $projectName = $request->input('projectName');

        return $this->projectService->get($projectName);
    }

    public function createFolder()
    {
    }
}
