<?php

namespace App\Controllers\V2;

use SolveX\Interfaces\RequestInterface as Request;
use App\Services\EmailService;

class EmailController
{
    public function __construct(EmailService $emailService)
    {
        $this->emailService = $emailService;
    }

    public function response(Request $req, $mailset, $interviewerId)
    {
        $imagePath = $this->emailService->markAsRead($interviewerId, $mailset, $req->input('token'));

        $fp = fopen($imagePath, 'rb');

        header("Content-Type: image/png");
        header("Content-Length: " . filesize($imagePath));

        fpassthru($fp);
        exit;
    }

}
